package com.digiwin.athena.atmc.http.restful.xiaohui.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

@Builder
@Data
@AllArgsConstructor
@NoArgsConstructor
public class MessageUrlDTO {
    /**
     * 接收人
     */
    private String targetUserId;
    /**
     * 内容
     */
    private MessageContext context;

    @Builder
    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    public static class MessageContext {
        /**
         * 标题
         */
        private String title;
        /**
         * 内容
         */
        private String text;
        /**
         * 按钮名称
         */
        private String label;
        /**
         * 按钮链接
         */
        private String uri;
    }

}
