package com.digiwin.athena.atmc.http.util;

import com.digiwin.athena.appcore.util.TimeUtils;
import lombok.extern.slf4j.Slf4j;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.TimeZone;

/**
 * AppTimeUtil Description
 *
 * @author majianfu
 * @date 2021/9/28
 * @since
 */
@Slf4j
public final class AppTimeUtil {
    public static final String UTC_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public static final String UTC_ZONE_ID_0 = "UTC";

    private AppTimeUtil() {
        throw new IllegalStateException("Unsupported init AppTimeUtil with constructor.");
    }

    public static String utcZone0ToLocal(String utcTime, String utcTimePattern, String localTimePattern) {
        return utcToLocal(utcTime, utcTimePattern, UTC_ZONE_ID_0, localTimePattern);
    }

    /**
     * UTC时间转本地时间
     * a
     *
     * @param utcTime
     * @param utcTimePattern
     * @param utcZoneId
     * @param localTimePattern
     * @return
     */
    public static String utcToLocal(String utcTime, String utcTimePattern, String utcZoneId, String localTimePattern) {
        SimpleDateFormat utcSdf = new SimpleDateFormat(utcTimePattern);
        utcSdf.setTimeZone(TimeZone.getTimeZone(utcZoneId));

        Date utcDate = null;
        try {
            utcDate = utcSdf.parse(utcTime);
        } catch (ParseException ex) {
            log.error("convert utc time failed, utcTime: {}, utcTimePattern: {}", utcTime, utcTimePattern);
            return utcTime;
        }

        SimpleDateFormat localSdf = new SimpleDateFormat(localTimePattern);
        localSdf.setTimeZone(TimeZone.getDefault());
        return localSdf.format(utcDate.getTime());
    }

    public static void checkTimeRange(String beginTimeStr, String endTimeStr, String errMsg) {
        LocalDateTime beginTime = TimeUtils.parse(beginTimeStr);
        LocalDateTime endTime = TimeUtils.parse(endTimeStr);
        // 时间校验
        if (beginTime.isAfter(endTime)) {
            throw new IllegalArgumentException(errMsg);
        }
    }
}
