package com.digiwin.athena.atmc.http.util;

import lombok.extern.slf4j.Slf4j;
import org.apache.http.util.Asserts;

import java.util.List;
import java.util.Objects;

/**
 * BatchDataOperation Description
 *
 * @author majianfu
 * @date 2024/4/25
 * @since
 */
@Slf4j
public class BatchDataOperation<T extends List<?>> {
    /**
     * 批量资源
     */
    private T dataList;

    /**
     * 默认构造函数
     *
     * @param dataList 数据列表
     */
    public BatchDataOperation(T dataList) {
        this.dataList = dataList;
    }

    /**
     * 执行批量操作
     *
     * @param action              回调方法
     * @param maxDataSizePerBatch 每次批处理的最大数据量
     */
    public void batchOperate(BatchConsumer<T> action, int maxDataSizePerBatch) {
        Asserts.check(maxDataSizePerBatch > 0, "maxDataSizePerBatch value must > 0.");
        Objects.requireNonNull(action);
        int length = dataList.size();
        for (int i = 0; i < length; i += maxDataSizePerBatch) {
            int toIndex = i + maxDataSizePerBatch;
            if (toIndex > length) {
                toIndex = length;
            }
            log.info("batch consume fromIndex:{} -- toIndex: {} ", i, toIndex);
            action.accept((T) dataList.subList(i, toIndex));
        }
    }
}
