/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.adsc.impl;

import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.action.SubmitActionDTO;
import com.digiwin.athena.atmc.http.restful.adsc.AdscService;
import com.digiwin.athena.atmc.http.restful.adsc.model.SubmitDataCheckResDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AdscServiceImpl
implements AdscService {
    private static final Logger log = LoggerFactory.getLogger(AdscServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    @Override
    public SubmitDataCheckResDto submitDataWithCheck(SubmitActionDTO submitActionDTO) {
        String url = this.envProperties.getWebAdscUri() + "/api/appdata/data/update";
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)submitActionDTO, (MultiValueMap)headers);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<SubmitDataCheckResDto>>(){}, new Object[0]);
            if (((BaseResultDTO)respEntity.getBody()).isOK()) {
                return (SubmitDataCheckResDto)((BaseResultDTO)respEntity.getBody()).getResponse();
            }
        }
        catch (Exception e) {
            log.error("\u63d0\u4ea4\u4efb\u52a1\u5230adsc\u670d\u52a1\u5f02\u5e38\uff1a{} ,url:{} ,\u8bf7\u6c42body\u4f53\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ADSC_APPDATA_DATA_UPDATE_EXCEPTION.getErrCode(), url, JsonUtils.objectToString((Object)submitActionDTO), e});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.ADSC_APPDATA_DATA_UPDATE_EXCEPTION.getErrCode(), (Exception)e);
        }
        return null;
    }

    @Override
    public void removeData(SubmitActionDTO submitActionDTO) {
        String url = this.envProperties.getWebAdscUri() + "/api/appdata/data/clear";
        HttpHeaders headers = new HttpHeaders();
        HttpEntity httpEntity = new HttpEntity((Object)submitActionDTO, (MultiValueMap)headers);
        try {
            this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        }
        catch (Exception e) {
            log.error("\u5220\u9664\u5230adsc\u7f13\u5b58\u5f02\u5e38\uff1a{},url:{} ,\u8bf7\u6c42body\u4f53\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.ADSC_APPDATA_DATA_UPDATE_EXCEPTION.getErrCode(), url, JsonUtils.objectToString((Object)submitActionDTO), e});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.ADSC_REMOVE_CACHE_EXCEPTION.getErrCode(), (Exception)e);
        }
    }
}

