/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.cac.impl;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.cac.CacService;
import com.digiwin.athena.atmc.http.restful.cac.model.AppAuthDTO;
import com.digiwin.athena.atmc.http.restful.cac.model.BaseCacResult;
import com.digiwin.athena.atmc.http.restful.cac.model.UserAppDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CacServiceImpl
implements CacService {
    private static final Logger log = LoggerFactory.getLogger(CacServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    @Override
    public AppAuthDTO queryAppAuth(String userId, String appCode) {
        AppAuthDTO result = null;
        String uri = this.envProperties.getIamCacUri() + "/api/cac/v4/authorizations/currentTenant/users/{userId}/goods/{appCode}/byUser";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        param.put("appCode", appCode);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<AppAuthDTO>(){}, param);
        result = (AppAuthDTO)responseEntity.getBody();
        return result;
    }

    @Override
    public List<UserAppDTO> qryUserApp() {
        String uri = this.envProperties.getIamCacUri() + "/api/cac/v4/authorizations/current/user/apps";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseCacResult<List<UserAppDTO>>>(){}, new Object[0]);
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(((BaseCacResult)responseEntity.getBody()).getCode())) {
                return (List)((BaseCacResult)responseEntity.getBody()).getData();
            }
        }
        catch (Exception e) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", (Object)e.getMessage());
        }
        return null;
    }

    @Override
    public List<String> queryUserByAppCode(String appCode) {
        String uri = this.envProperties.getIamCacUri() + "/api/cac/v4/counting/currenttenant/goods/{goodsCode}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("goodsCode", appCode);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<List<String>>(){}, param);
            return (List)responseEntity.getBody();
        }
        catch (Exception e) {
            log.error("execute cac [/counting/currenttenant/goods/{goodsCode}] fail, message = {}", (Object)e.getMessage());
            return new ArrayList<String>();
        }
    }

    @Override
    public List<UserAppDTO> qryUserAppByUserId(String userId) {
        String uri = this.envProperties.getIamCacUri() + "/api/cac/v4/authorizations/current/user/apps?userId={userId}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("userId", userId);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseCacResult<List<UserAppDTO>>>(){}, param);
            if (null != responseEntity.getBody() && String.valueOf(HttpStatus.OK.value()).equals(((BaseCacResult)responseEntity.getBody()).getCode())) {
                return (List)((BaseCacResult)responseEntity.getBody()).getData();
            }
        }
        catch (Exception e) {
            log.error("execute cac [/authorizations/current/user/apps] fail, message = {}", (Object)e.getMessage());
        }
        return null;
    }
}

