/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.cam.impl;

import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.cac.model.BaseCacResult;
import com.digiwin.athena.atmc.http.restful.cam.CamService;
import com.digiwin.athena.atmc.http.restful.cam.model.AppMappingsDTO;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class CamServiceImpl
implements CamService {
    private static final Logger log = LoggerFactory.getLogger(CamServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public Map<String, String> getAppMappings(String userToken, String appCode) {
        Map<Object, Object> appMappingMap = Maps.newHashMap();
        if (StringUtils.isEmpty((String)appCode)) {
            return appMappingMap;
        }
        String url = this.envProperties.getCamUri() + "/api/cam/v1/app/mappings?code=%s";
        url = String.format(url, appCode);
        HttpHeaders headers = new HttpHeaders();
        headers.set("digi-middleware-auth-user", userToken);
        headers.set("digi-middleware-auth-app", "eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJpZCI6IkF0aGVuYSIsInNpZCI6MTYzNjc3NzI1NzgyNTkyfQ.3QLTPVKsk2Mp3j_aQ3X8bQW1wCJMNWeCkL6VPoK352c");
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        try {
            log.info("\u8bf7\u6c42CAM\u83b7\u53d6\u5e94\u7528\u4fe1\u606f \u5165\u53c2:{}", (Object)JsonUtils.objectToString((Object)httpEntity));
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseCacResult<List<AppMappingsDTO>>>(){}, new Object[0]);
            if (respEntity.getStatusCode().value() != 200) {
                log.info("\u8bf7\u6c42CAM\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u8fd4\u56de\u9519\u8bef\uff0c\u5165\u53c2appCode\uff1a{}, resp\uff1a{}", (Object)appCode, (Object)JsonUtils.objectToString((Object)respEntity));
                return appMappingMap;
            }
            List appMappingsDTOList = (List)((BaseCacResult)respEntity.getBody()).getData();
            if (CollectionUtils.isEmpty((Collection)appMappingsDTOList)) {
                return appMappingMap;
            }
            List ddAppMappingsList = appMappingsDTOList.stream().filter(appMappings -> appMappings.getPlatform().equals(AppMappingsDTO.PLATFORM_DINGDING)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(ddAppMappingsList)) {
                return appMappingMap;
            }
            AppMappingsDTO appMappingsDTO = (AppMappingsDTO)ddAppMappingsList.get(0);
            appMappingMap = appMappingsDTO.getDatas().stream().collect(Collectors.toMap(AppMappingsDatasDTO2 -> AppMappingsDatasDTO2.getKey(), part -> part.getValue()));
        }
        catch (BusinessException ex) {
            log.error("\u8bf7\u6c42CAM\u83b7\u53d6\u5e94\u7528\u4fe1\u606f\u62a5\u9519\uff0c\u5165\u53c2appCode\uff1a{}, ex\uff1a{}", (Object)appCode, (Object)ex);
        }
        return appMappingMap;
    }
}

