/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.emc.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.restful.emc.EmcService;
import com.digiwin.athena.atmc.http.restful.emc.model.AppMessageDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class EmcServiceImpl
implements EmcService {
    private static final Logger log = LoggerFactory.getLogger(EmcServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    @Override
    public void pushMessage(String token, AppMessageDTO appMessageDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HttpEntity httpEntity = new HttpEntity((Object)appMessageDTO, (MultiValueMap)headers);
        String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/push";
        try {
            String code;
            HashMap result;
            ResponseEntity roleResponseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, HashMap.class, new Object[0]);
            if (roleResponseEntity.getBody() == null && null != (result = (HashMap)roleResponseEntity.getBody()) && result.get("code") != null && !"200".equals(code = result.get("code").toString())) {
                throw BusinessException.create((String)ErrorCodeEnum.EMC_MESSAGE_PUSH.getErrCode(), (String)result.get("message").toString());
            }
        }
        catch (Exception ex) {
            log.error("{}, \u8bf7\u6c42body\u4f53\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.EMC_MESSAGE_PUSH.getErrCode(), JsonUtils.objectToString((Object)appMessageDTO), ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.EMC_MESSAGE_PUSH.getErrCode(), (Exception)ex);
        }
    }

    @Override
    public List<Map<String, Object>> getNoticesSettings(AuthoredUser user, String previewId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        String url = this.envProperties.getEmcUri() + AtmcStrUtil.format("/api/emc/v2/notices/settings/{previewId}", previewId);
        try {
            ResponseEntity noticeResp = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, List.class, new Object[0]);
            if (noticeResp.getStatusCode() == HttpStatus.OK && noticeResp.getBody() == null) {
                return new ArrayList<Map<String, Object>>();
            }
            return (List)noticeResp.getBody();
        }
        catch (Exception ex) {
            log.error("{}, url\uff1a{}, \u62a5\u9519\u4fe1\u606f\uff1a{}", new Object[]{ErrorCodeEnum.EMC_GET_NOTICE_SETTINGS_FAIL.getErrCode(), url, ex});
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.EMC_GET_NOTICE_SETTINGS_FAIL.getErrCode(), (Exception)ex);
        }
    }
}

