/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.iam.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.eoc.model.EocResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.BossIamService;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamAddUserResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamCheckUserResultDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamTenantAuthDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.BossIamTenantDTO;
import com.github.pagehelper.util.StringUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class BossIamServiceImpl
implements BossIamService {
    private static final Logger log = LoggerFactory.getLogger(BossIamServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public BossIamCheckUserResultDTO checkTenantUser(String tenantId, String appId, String email) {
        BossIamCheckUserResultDTO result = null;
        String uri = this.envProperties.getIamBossUri() + "/api/boss/v1/users/check/user/tenant/auth?tenantId={tenantId}&appId={appId}&email={email}";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        param.put("appId", appId);
        param.put("email", email);
        HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.GET, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, param);
        Map body = (Map)responseEntity.getBody();
        if (body.containsKey("data")) {
            result = (BossIamCheckUserResultDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString(body.get("data")), BossIamCheckUserResultDTO.class);
        }
        return result;
    }

    @Override
    public BossIamAddUserResultDTO addTenantUser(String tenantId, String email, String pwd, String appId) {
        String uri = this.envProperties.getIamBossUri() + "/api/boss/v1/users/enterprise";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", tenantId);
        param.put("id", email);
        param.put("name", email);
        param.put("password", pwd);
        param.put("email", email);
        param.put("telephone", "");
        param.put("sendEmail", true);
        HashMap<String, Object> appParam = new HashMap<String, Object>();
        appParam.put("sid", 199246554387008L);
        appParam.put("id", appId);
        appParam.put("name", appId);
        ArrayList<HashMap<String, Object>> apps = new ArrayList<HashMap<String, Object>>();
        apps.add(appParam);
        param.put("app", apps);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BossIamAddUserResultDTO>(){}, new HashMap());
        return (BossIamAddUserResultDTO)responseEntity.getBody();
    }

    @Override
    public Map<String, Object> getTenantAuth(AuthoredUser authoredUser, String email, String telephone, String appId, Integer tenantType) {
        HashMap<String, Object> resultMap = new HashMap<String, Object>();
        if (StringUtil.isEmpty((String)email) && StringUtil.isEmpty((String)telephone)) {
            return null;
        }
        appId = StringUtil.isNotEmpty((String)appId) ? appId : "Athena";
        tenantType = tenantType != null ? tenantType : 0;
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/email/tenants/auth";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("email", email);
        param.put("telephone", telephone);
        param.put("appId", appId);
        param.put("tenantType", tenantType);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
            if (responseEntity == null || responseEntity.getStatusCode() != HttpStatus.OK) {
                resultMap.put("status", -1);
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25");
                return resultMap;
            }
            EocResultDTO eocResultDTO = (EocResultDTO)responseEntity.getBody();
            if (eocResultDTO == null) {
                resultMap.put("status", -1);
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25");
                return resultMap;
            }
            BossIamTenantAuthDTO bossIamTenantAuthDTO = (BossIamTenantAuthDTO)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)eocResultDTO.getData()), BossIamTenantAuthDTO.class);
            List<BossIamTenantDTO> bossIamTenantDTOS = bossIamTenantAuthDTO.getTenants();
            if (CollectionUtils.isEmpty(bossIamTenantDTOS)) {
                resultMap.put("status", 0);
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a\u6ca1\u6709\u4e2a\u4eba\u79df\u6237");
                return resultMap;
            }
            BossIamTenantDTO bossIamTenantDTO = bossIamTenantDTOS.get(0);
            if (!bossIamTenantDTO.getIsTenantAuth().booleanValue() || !bossIamTenantDTO.getIsUserAuth().booleanValue()) {
                resultMap.put("status", 1);
                resultMap.put("userId", bossIamTenantAuthDTO.getUserId());
                resultMap.put("tenantId", bossIamTenantDTO.getId());
                resultMap.put("isTenantAuth", bossIamTenantDTO.getIsTenantAuth());
                resultMap.put("isUserAuth", bossIamTenantDTO.getIsUserAuth());
                log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff08\u6ca1\u6709\u6388\u6743\uff09\uff1a{}", (Object)bossIamTenantAuthDTO);
                return resultMap;
            }
            resultMap.put("status", 2);
            resultMap.put("userId", bossIamTenantAuthDTO.getUserId());
            resultMap.put("tenantId", bossIamTenantDTO.getId());
            resultMap.put("isTenantAuth", bossIamTenantDTO.getIsTenantAuth());
            resultMap.put("isUserAuth", bossIamTenantDTO.getIsUserAuth());
        }
        catch (Exception e) {
            resultMap.put("status", -1);
            log.error("\u83b7\u53d6\u7528\u6237\u5f52\u5c5e\u7684\u79df\u6237\u4ee5\u53ca\u6307\u5b9a\u5e94\u7528\u6388\u6743\u4fe1\u606f\u5931\u8d25\uff1a{}", (Throwable)e);
        }
        return resultMap;
    }

    @Override
    public Map<String, String> registerTenant(AuthoredUser authoredUser, String email, String telephone, String appId, String strategySid, String strategyCode) {
        Map<String, String> resultMap = new HashMap<String, String>();
        if (StringUtil.isEmpty((String)email)) {
            return resultMap;
        }
        appId = StringUtil.isNotEmpty((String)appId) ? appId : "Athena";
        strategyCode = StringUtil.isNotEmpty((String)strategyCode) ? strategyCode : "athena_light_01";
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/individual/tenant/register";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", authoredUser.getToken());
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("email", email);
        param.put("telephone", telephone);
        param.put("appId", appId);
        param.put("strategySid", strategySid);
        param.put("strategyCode", strategyCode);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        if (responseEntity != null && responseEntity.getStatusCode() == HttpStatus.OK && responseEntity.getBody() != null) {
            Object data = ((EocResultDTO)responseEntity.getBody()).getData();
            resultMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString((Object)data), Map.class);
        }
        return resultMap;
    }

    @Override
    public Boolean authorizeUser(AuthoredUser authoredUser, String tenantId, String email, String telephone, String appId, String strategySid, String strategyCode, Boolean isTenantAuth) {
        Boolean result = true;
        if (StringUtil.isEmpty((String)email) && StringUtil.isEmpty((String)tenantId)) {
            return Boolean.FALSE;
        }
        appId = StringUtil.isNotEmpty((String)appId) ? appId : "Athena";
        strategyCode = StringUtil.isNotEmpty((String)strategyCode) ? strategyCode : "athena_light_01";
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/tenant/user/auth";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("tenantId", tenantId);
        param.put("email", email);
        param.put("telephone", telephone);
        param.put("appId", appId);
        param.put("strategySid", strategySid);
        param.put("strategyCode", strategyCode);
        param.put("isTenantAuth", isTenantAuth);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, EocResultDTO.class, new HashMap());
        if (responseEntity != null && responseEntity.getStatusCode() == HttpStatus.OK && responseEntity.getBody() != null) {
            result = Boolean.valueOf(((EocResultDTO)responseEntity.getBody()).getData().toString());
        }
        return result;
    }
}

