/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.iam.impl;

import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.iam.RoleService;
import com.digiwin.athena.atmc.http.restful.iam.model.RoleDTO;
import com.digiwin.athena.atmc.http.restful.iam.model.UserRoleDTO;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class RoleServiceImpl
implements RoleService {
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;

    @Override
    public List<RoleDTO> queryUserRoles(String userId) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/role";
        ResponseEntity roleResponseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserRoleDTO.class, new Object[0]);
        if (roleResponseEntity.getBody() == null) {
            return new ArrayList<RoleDTO>();
        }
        return ((UserRoleDTO)roleResponseEntity.getBody()).getRoles();
    }

    @Override
    public List<RoleDTO> queryUserRoles(String userId, String token) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("id", userId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        String url = this.envProperties.getIamUri() + "/api/iam/v2/user/role";
        ResponseEntity roleResponseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, UserRoleDTO.class, new Object[0]);
        if (roleResponseEntity.getBody() == null) {
            return new ArrayList<RoleDTO>();
        }
        return ((UserRoleDTO)roleResponseEntity.getBody()).getRoles();
    }
}

