/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.smartdata.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.exception.BusinessException;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.domain.misc.DemoCreateDTO;
import com.digiwin.athena.atmc.http.domain.misc.DemoItemResultDTO;
import com.digiwin.athena.atmc.http.restful.ptm.model.PtmDataFootPrintDTO;
import com.digiwin.athena.atmc.http.restful.smartdata.SmartDataService;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SmartDataSerivceImpl
implements SmartDataService {
    private static final Logger log = LoggerFactory.getLogger(SmartDataSerivceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    @Override
    public Map clearDataByTenantId(String tenantId) {
        String uri = this.envProperties.getSdDataFootPrintUri() + "restful/service/DataFootprint/devOps/all";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.DELETE, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, param);
        return (Map)responseEntity.getBody();
    }

    @Override
    public Map presetDataByTenantId(String tenantId) {
        String uri = this.envProperties.getSdDataFootPrintUri() + "restful/service/DataFootprint/prepareData/presetData";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("tenantId", tenantId);
        HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, param);
        return (Map)responseEntity.getBody();
    }

    @Override
    public Object clearComparisonData(AuthoredUser user, String instanceId, String activityCode, String entityName, Map<String, String> eocMap, List<Map> bkList) {
        Object result = new Object();
        String uri = this.envProperties.getSdDataComparisonUri() + "/restful/standard/datacomparison/comparison/v1/stop";
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", user.getTenantId());
        body.put("eocMap", eocMap);
        body.put("instanceId", instanceId);
        body.put("tempId", activityCode);
        body.put("bks", bkList);
        body.put("entityName", entityName);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        log.info("clearComparisonData body: {}", (Object)JsonUtils.objectToString(body));
        ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        result = ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
        return result;
    }

    @Override
    public PtmDataFootPrintDTO queryByActTmpId(String taskCode, Map<String, Object> bk) {
        ResponseEntity responseEntity;
        String url = this.envProperties.getSdDataFootPrintUri() + "restful/service/DataFootprint/activity/queryByActTmpId";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, Object> rootPara = new HashMap<String, Object>();
        rootPara.put("taskCode", taskCode);
        rootPara.put("bkInfo", bk);
        log.info("\u6839\u636etaskCode\u3001bk\u67e5\u8be2\u6570\u636e\u8f68\u8ff9 \uff0cdata\uff1a{}", (Object)JsonUtils.objectToString(rootPara));
        HttpEntity httpEntity = new HttpEntity(rootPara, (MultiValueMap)headers);
        try {
            responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<PtmDataFootPrintDTO>>(){}, rootPara);
        }
        catch (Exception e) {
            log.error("[atmc\u8bbf\u95eeDFP \u6839\u636etaskCode\u3001bk\u67e5\u8be2\u6570\u636e\u8f68\u8ff9  \u65f6\u51fa\u73b0\u5f02\u5e38(/restful/service/DataFootprint/activity/queryByActTmpId)] error:{}, stack:{}, data:{}", new Object[]{e, e.getStackTrace(), rootPara});
            String message = MessageFormat.format(this.messageUtils.getMessage("exception.ptm.smartdata.bpmdata.fail"), JsonUtils.objectToString(rootPara));
            throw BusinessException.create((Integer)599, (String)"599", (Object)message, (String)e.getMessage(), (String)this.messageUtils.getMessage("exception.ptm.smartdata.bpmdata.fail"), (Throwable)e);
        }
        return (PtmDataFootPrintDTO)((BaseResultDTO)Objects.requireNonNull(responseEntity.getBody())).getResponse();
    }

    @Override
    public DemoItemResultDTO smartDataRecordData(String tenantId, String baseDate) {
        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("SmartData \u5f55\u5236\u6570\u636e");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<String>());
        List<String> msgList = result.getMessage();
        try {
            String uri = this.envProperties.getSdDataFootPrintUri() + "restful/service/DataFootprint/prepareData/initData";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("baseDate", baseDate);
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, param);
            Map r = (Map)responseEntity.getBody();
            if (!r.containsKey("status") || !Objects.equals(r.get("status"), 200)) {
                msgList.add("SmartData \u5f55\u5236\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
                result.setSuccess(false);
                log.error("[SmartData \u5f55\u5236\u6570\u636e]", (Object)r);
            }
        }
        catch (Exception ex) {
            result.setSuccess(false);
            msgList.add("SmartData \u5f55\u5236\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
            msgList.add(ex.getMessage());
            log.error("[SmartData \u5f55\u5236\u6570\u636e]", (Throwable)ex);
        }
        result.setEndTime(LocalDateTime.now());
        return result;
    }

    @Override
    public DemoItemResultDTO smartDataDeleteData(String tenantId) {
        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("SmartData \u6e05\u9664\u6570\u636e");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<String>());
        List<String> msgList = result.getMessage();
        try {
            String uri = this.envProperties.getSdDataFootPrintUri() + "restful/service/DataFootprint/devOps/all";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("tenantId", tenantId);
            param.put("secure", "");
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.DELETE, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, param);
            Map m = (Map)responseEntity.getBody();
            if (!m.containsKey("status") || !Objects.equals(m.get("status"), 200)) {
                msgList.add("SmartData \u6e05\u9664\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
                result.setSuccess(false);
                log.error("[SmartData \u6e05\u9664\u6570\u636e]", (Object)m);
            }
        }
        catch (Exception ex) {
            result.setSuccess(false);
            msgList.add("SmartData \u6e05\u9664\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
            msgList.add(ex.getMessage());
            log.error("[SmartData \u6e05\u9664\u6570\u636e]", (Throwable)ex);
        }
        result.setEndTime(LocalDateTime.now());
        return result;
    }

    @Override
    public DemoItemResultDTO smartDataCreateData(DemoCreateDTO dto) {
        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("SmartData \u91cd\u7f6e\u6570\u636e");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<String>());
        List<String> msgList = result.getMessage();
        try {
            String uri = this.envProperties.getSdDataFootPrintUri() + "restful/service/DataFootprint/prepareData/presetData";
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            HashMap<String, String> param = new HashMap<String, String>();
            param.put("sourceTenantId", dto.getSourceTenantId());
            param.put("targetTenantId", dto.getTargetTenantId());
            param.put("baseDate", dto.getBaseDate());
            HttpEntity httpEntity = new HttpEntity(param, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Map>(){}, param);
            Map m = (Map)responseEntity.getBody();
            if (!m.containsKey("status") || !Objects.equals(m.get("status"), 200)) {
                msgList.add("SmartData \u91cd\u7f6e\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
                result.setSuccess(false);
                log.error("[SmartData \u91cd\u7f6e\u6570\u636e]", (Object)m);
            }
        }
        catch (Exception ex) {
            result.setSuccess(false);
            msgList.add("SmartData \u91cd\u7f6e\u6570\u636e \u51fa\u73b0\u5f02\u5e38\uff0c\u8be6\u60c5\u67e5\u770b\u65e5\u5fd7");
            msgList.add(ex.getMessage());
            log.error("[SmartData \u91cd\u7f6e\u6570\u636e]", (Throwable)ex);
        }
        result.setEndTime(LocalDateTime.now());
        return result;
    }

    @Override
    public void deleteDataComparison(String tenantId, String type, List<String> instanceIds) {
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("tenantId", tenantId);
        body.put("type", type);
        body.put("instanceIds", instanceIds);
        String url = this.envProperties.getSdDataComparisonUri() + "restful/standard/datacomparison/comparison/v1/task/delete";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(body, (MultiValueMap)headers);
        log.info("deleteDataComparison body: {}", (Object)JsonUtils.objectToString(body));
        this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
    }
}

