/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.util;

import com.digiwin.athena.appcore.util.TimeUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class AppTimeUtil {
    private static final Logger log = LoggerFactory.getLogger(AppTimeUtil.class);
    public static final String UTC_TIME_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    public static final String UTC_ZONE_ID_0 = "UTC";

    private AppTimeUtil() {
        throw new IllegalStateException("Unsupported init AppTimeUtil with constructor.");
    }

    public static String utcZone0ToLocal(String utcTime, String utcTimePattern, String localTimePattern) {
        return AppTimeUtil.utcToLocal(utcTime, utcTimePattern, UTC_ZONE_ID_0, localTimePattern);
    }

    public static String utcToLocal(String utcTime, String utcTimePattern, String utcZoneId, String localTimePattern) {
        SimpleDateFormat utcSdf = new SimpleDateFormat(utcTimePattern);
        utcSdf.setTimeZone(TimeZone.getTimeZone(utcZoneId));
        Date utcDate = null;
        try {
            utcDate = utcSdf.parse(utcTime);
        }
        catch (ParseException ex) {
            log.error("convert utc time failed, utcTime: {}, utcTimePattern: {}", (Object)utcTime, (Object)utcTimePattern);
            return utcTime;
        }
        SimpleDateFormat localSdf = new SimpleDateFormat(localTimePattern);
        localSdf.setTimeZone(TimeZone.getDefault());
        return localSdf.format(utcDate.getTime());
    }

    public static void checkTimeRange(String beginTimeStr, String endTimeStr, String errMsg) {
        LocalDateTime endTime;
        LocalDateTime beginTime = TimeUtils.parse((String)beginTimeStr);
        if (beginTime.isAfter(endTime = TimeUtils.parse((String)endTimeStr))) {
            throw new IllegalArgumentException(errMsg);
        }
    }
}

