/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.asa.impl;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.AsaApiConstant;
import com.digiwin.athena.atmc.http.restful.asa.AsaRService;
import com.digiwin.athena.atmc.http.restful.asa.model.AsaBacklogDTO;
import com.digiwin.athena.atmc.http.restful.asa.model.AsaProjectDTO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class AsaRServiceImpl
implements AsaRService {
    private static final Logger log = LoggerFactory.getLogger(AsaRServiceImpl.class);
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private EnvProperties envProperties;

    @Override
    public void ptmMqMessageReceiveAsa(AsaBacklogDTO asaBacklogDTO) {
        String url = this.envProperties.getAsaUri() + AsaApiConstant.COLLECT_CAPACITY_CREATE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", AppAuthContextHolder.getContext().getAuthoredUser().getToken());
        HttpEntity httpEntity = new HttpEntity((Object)asaBacklogDTO, (MultiValueMap)headers);
        log.info("AsaRServiceImpl.ptmMqMessageReceiveAsa.asaBacklogDTO:{}", (Object)asaBacklogDTO);
        ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, JSONObject.class, new Object[0]);
        log.info("AsaRServiceImpl.ptmMqMessageReceiveAsa.result:{}", (Object)response);
    }

    @Override
    public void ptmMqProjectMessageReceiveAsa(AsaProjectDTO asaProjectDTO, AuthoredUser user) {
        String url = this.envProperties.getAsaUri() + AsaApiConstant.ASA_ATMC_DISTRIBUTE;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        HttpEntity httpEntity = new HttpEntity((Object)asaProjectDTO, (MultiValueMap)headers);
        log.info("AsaRServiceImpl.ptmMqProjectMessageReceiveAsa.httpEntity:{}", (Object)JSON.toJSONString((Object)httpEntity));
        try {
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, JSONObject.class, new Object[0]);
            log.info("AsaRServiceImpl.ptmMqProjectMessageReceiveAsa.result:{}", (Object)response);
        }
        catch (Exception e) {
            log.error("AsaRServiceImpl.ptmMqProjectMessageReceiveAsa error:{}", (Throwable)e);
        }
    }
}

