/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.im.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.im.ImService;
import com.digiwin.athena.atmc.http.restful.im.model.IMSendMessageDTO;
import com.digiwin.athena.atmc.http.restful.im.model.ImNeteaseUserDTO;
import com.digiwin.athena.atmc.http.restful.im.model.TeamMemberInfoDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class ImServiceImpl
implements ImService {
    private static final Logger log = LoggerFactory.getLogger(ImServiceImpl.class);
    @Resource
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MessageUtils messageUtils;

    private boolean disableIM() {
        return StringUtils.isBlank((String)this.getImUri());
    }

    @Override
    public List<TeamMemberInfoDTO> queryTeamMembers(Long tid) {
        String url = this.getImUri() + AtmcStrUtil.format("/team/getTeamMembers/{tid}", tid);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, null, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<TeamMemberInfoDTO>>>(){}, new Object[0]);
        return (List)((BaseResultDTO)respEntity.getBody()).getResponseWithException(this.messageUtils.getMessage("exception.im.get.team.members.fail"));
    }

    private String getImUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getImUri();
    }

    @Override
    public void pushMessage(String token, IMSendMessageDTO messageDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", token);
        String url = this.getImUri() + "/api/im/v1/push";
        HttpEntity httpEntity = new HttpEntity((Object)messageDTO, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Void>>(){}, new Object[0]);
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<ImNeteaseUserDTO> queryNeteaseUsers(List<String> userIdList) {
        List<ImNeteaseUserDTO> result = new ArrayList<ImNeteaseUserDTO>();
        String url = this.getImUri() + "/user/getUserInfoByUserIds";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HashMap<String, List<String>> condition = new HashMap<String, List<String>>();
        condition.put("userIds", userIdList);
        HttpEntity httpEntity = new HttpEntity(condition, (MultiValueMap)headers);
        ResponseEntity responseEntity = null;
        responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<ImNeteaseUserDTO>>>(){}, condition);
        if (((BaseResultDTO)responseEntity.getBody()).isOK() && ((BaseResultDTO)responseEntity.getBody()).getResponse() != null) {
            result = (List)((BaseResultDTO)responseEntity.getBody()).getResponse();
        }
        return result;
    }

    @Override
    public void removeTeam(String bizId, int type, AuthoredUser user) {
        if (this.disableIM()) {
            return;
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", user.getToken());
            String url = this.getImUri() + "/team/removeTeam";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("bizId", bizId);
            paramMap.put("type", type);
            paramMap.put("source", "atmc");
            HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void updateTeamInfo(AuthoredUser user, String tid, String cardIds) {
        if (this.disableIM()) {
            return;
        }
        Object resultMap = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/updateTeam";
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("tid", tid);
        paramMap.put("cardIds", cardIds);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        log.info("\u66f4\u65b0\u7fa4\u6d88\u606f\uff1a{}", (Object)responseEntity);
    }

    @Override
    public void addTeamMembers(AuthoredUser user, String bizId, int type, List<String> memberList) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/addMembers";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bizId", bizId);
        paramMap.put("type", type);
        paramMap.put("memberIds", memberList);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        System.out.println(responseEntity);
    }

    @Override
    public void createTeam(AuthoredUser user, String owner, String teamName, String bizId, int type, int ifMaster, int visiable, List<String> memberList, String pId, List<Map> externalAccounts, List<Map> externalEocMembers, String businessKey) {
        if (memberList != null && memberList.size() > 0) {
            memberList.removeIf(s -> StringUtils.isEmpty((String)s));
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/createAsync";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("owner", owner);
        paramMap.put("teamName", teamName);
        paramMap.put("bizName", teamName);
        paramMap.put("bizId", bizId);
        paramMap.put("type", type);
        paramMap.put("ifMaster", ifMaster);
        paramMap.put("visible", visiable);
        paramMap.put("memberIds", memberList);
        paramMap.put("pId", pId);
        paramMap.put("source", "atmc");
        if (externalAccounts != null && externalAccounts.size() > 0) {
            paramMap.put("externalAccounts", externalAccounts);
        }
        if (externalEocMembers != null && externalEocMembers.size() > 0) {
            paramMap.put("externalEocMembers", externalEocMembers);
        }
        paramMap.put("businessKey", businessKey);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        System.out.println(responseEntity);
    }

    @Override
    public Map getTeamInfo(AuthoredUser user, String bizId, int type, String source) {
        Object response;
        if (this.disableIM()) {
            return null;
        }
        Map resultMap = null;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("digi-middleware-auth-user", user.getToken());
        String url = this.getImUri() + "/team/getMasterByBizIdAndTypeAndSource";
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        paramMap.put("bizId", bizId);
        paramMap.put("type", type);
        paramMap.put("source", source);
        HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
        if (responseEntity.getStatusCode() == HttpStatus.OK && (response = ((Map)responseEntity.getBody()).get("response")) != null && response != "") {
            resultMap = (Map)JsonUtils.jsonToObject((String)JsonUtils.objectToString(response), Map.class);
        }
        return resultMap;
    }

    @Override
    public Map<String, Integer> clearDataByTenantSid(AuthoredUser user) {
        HashMap<String, Integer> resultMap = new HashMap<String, Integer>();
        try {
            if (this.disableIM()) {
                return resultMap;
            }
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", user.getToken());
            String url = this.getImUri() + AtmcStrUtil.format("/team/clearDataByTenantSid/{tenantSid}", user.getTenantSid());
            HttpEntity httpEntity = new HttpEntity((MultiValueMap)headers);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, httpEntity, Map.class, new Object[0]);
            if (responseEntity != null && responseEntity.getStatusCode() == HttpStatus.OK) {
                resultMap.put("code", 200);
                log.info("\u6839\u636e\u79df\u6237\u6e05\u9664IM\u6570\u636e\u6210\u529f\uff01");
            } else {
                resultMap.put("code", 500);
            }
        }
        catch (Exception e) {
            resultMap.put("code", 500);
            log.error("\u6839\u636e\u79df\u6237\u6e05\u9664IM\u6570\u636e\u5931\u8d25\uff1a{}", (Object)e.getMessage());
        }
        return resultMap;
    }

    @Override
    public void removeTeamByParam(String bizId, int type, String cardId, String businessKey, AuthoredUser user) {
        if (this.disableIM()) {
            return;
        }
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add("digi-middleware-auth-user", user.getToken());
            String url = this.getImUri() + "/team/removeTeam";
            HashMap<String, Object> paramMap = new HashMap<String, Object>();
            paramMap.put("bizId", bizId);
            paramMap.put("type", type);
            paramMap.put("cardId", cardId);
            paramMap.put("businessKey", businessKey);
            paramMap.put("source", "pcc");
            HttpEntity httpEntity = new HttpEntity(paramMap, (MultiValueMap)headers);
            log.info("\u6279\u91cf\u89e3\u6563\u7fa4\uff1a{}", paramMap);
            ResponseEntity response = this.restTemplate.postForEntity(url, (Object)httpEntity, Map.class, new Object[0]);
            log.info("\u6279\u91cf\u89e3\u6563\u7fa4\u6210\u529f\uff1a{}", (Object)response);
        }
        catch (Exception e) {
            log.error("\u6279\u91cf\u89e3\u6563\u7fa4\u5931\u8d25\uff1a{}", (Throwable)e);
        }
    }
}

