/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.semc.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.restful.semc.TddService;
import com.digiwin.athena.atmc.http.restful.semc.model.EncryptedConfigDTO;
import com.digiwin.athena.atmc.http.restful.semc.model.EncryptedConfigVO;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class TddServiceImpl
implements TddService {
    private static final Logger log = LoggerFactory.getLogger(TddServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public EncryptedConfigVO getEncryptedConfig(EncryptedConfigDTO encryptedConfigDTO) {
        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = this.envProperties.getTddUri() + "/encrypted/getEncryptedConfig";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add("digi-middleware-auth-user", authoredUser.getToken());
            HttpEntity requestEntity = new HttpEntity((Object)encryptedConfigDTO, (MultiValueMap)headers);
            ResponseEntity resultDTOResponseEntity = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<EncryptedConfigVO>>(){}, new Object[0]);
            return (EncryptedConfigVO)((BaseResultDTO)resultDTOResponseEntity.getBody()).getResponseWithException("");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public String makePassword(Integer passwordStreflgth, Integer passwordLength) {
        String url = this.envProperties.getTddUri() + "/encrypted/makePassword";
        HashMap<String, Integer> params = new HashMap<String, Integer>();
        params.put("defenceComplexity", passwordStreflgth);
        params.put("defenceLength", passwordLength);
        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(params, (MultiValueMap)headerMap);
        try {
            ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
            Map response = (Map)((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
            if (response.containsKey("defence")) {
                return response.get("defence") + "";
            }
        }
        catch (Exception ex) {
            log.error("[queryRowDataAttachmentList] body: {}, error: ", (Object)JsonUtils.objectToString(params), (Object)ex);
        }
        return null;
    }
}

