/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.atdm.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.HttpUtils;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.action.MergeSubmitActionDTO;
import com.digiwin.athena.atmc.http.domain.action.SubmitActionDTO;
import com.digiwin.athena.atmc.http.domain.action.SubmitExecuteContext;
import com.digiwin.athena.atmc.http.restful.aglie.model.QueryDataByActionVO;
import com.digiwin.athena.atmc.http.restful.atdm.AtdmService;
import com.digiwin.athena.atmc.http.restful.atdm.model.QueryResult;
import com.digiwin.athena.atmc.http.restful.atdm.model.QueryResultSet;
import com.digiwin.athena.atmc.http.restful.atdm.model.RecycleRecordStateChangeDTO;
import com.fasterxml.jackson.core.type.TypeReference;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.sf.json.JSONObject;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestTemplate;

@Service
public class AtdmServiceImpl
implements AtdmService {
    private static final Logger log = LoggerFactory.getLogger(AtdmServiceImpl.class);
    @Autowired
    EnvProperties envProperties;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    MessageUtils messageUtils;

    @Override
    public Map submitTask(SubmitActionDTO submitAction) {
        if (submitAction.getAction() == null) {
            throw new IllegalArgumentException("submitAction.getAction()");
        }
        String url = this.getAtdmUri() + "api/atdm/v1/action/submit/task";
        url = AtdmServiceImpl.appendTraceInfo(url, submitAction.getAction().getExecuteContext(), submitAction.getAction().getActionId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        submitAction.setOperateAuthoredUser(AppAuthContextHolder.getContext().getAuthoredUser());
        HttpEntity httpEntity = new HttpEntity((Object)submitAction, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (Map)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<Map>(){});
    }

    private String getAtdmUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getAtdmUri();
    }

    @Override
    public Map executeTask(SubmitActionDTO submitAction) {
        String url = this.getAtdmUri() + "api/atdm/v1/action/execute";
        url = AtdmServiceImpl.appendTraceInfo(url, submitAction.getAction().getExecuteContext(), submitAction.getAction().getActionId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((Object)submitAction, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<Object>(){}, new Object[0]);
        return (Map)HttpUtils.descResponseBody((String)url, null, (ResponseEntity)respEntity, (TypeReference)new TypeReference<Map>(){});
    }

    @Override
    public BaseResultDTO queryByActionId(Map action) {
        String uri = this.getAtdmUri() + "api/atdm/v1/data/query/by/actionId";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((Object)action, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Map>>(){}, new Object[0]);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public List<Map> submitMergeTask(List<SubmitActionDTO> mergeActionList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(mergeActionList)) {
            return new ArrayList<Map>();
        }
        if (mergeActionList.get(0) == null) {
            throw new IllegalArgumentException("submitAction.getAction()");
        }
        String uri = this.getAtdmUri() + "api/atdm/v1/action/submit/mergeTask";
        uri = AtdmServiceImpl.appendTraceInfo(uri, mergeActionList.get(0).getAction().getExecuteContext(), mergeActionList.get(0).getAction().getActionId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mergeActionList)) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            mergeActionList.stream().forEach(action -> action.setOperateAuthoredUser(authoredUser));
        }
        HttpEntity httpEntity = new HttpEntity(mergeActionList, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
        return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    @Override
    public List<Map> submitMergeTaskCrossBk(List<SubmitActionDTO> mergeActionList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(mergeActionList)) {
            return new ArrayList<Map>();
        }
        if (mergeActionList.get(0) == null) {
            throw new IllegalArgumentException("submitAction.getAction()");
        }
        String uri = this.getAtdmUri() + "api/atdm/v1/action/submit/mergeTaskCrossBk";
        uri = AtdmServiceImpl.appendTraceInfo(uri, mergeActionList.get(0).getAction().getExecuteContext(), mergeActionList.get(0).getAction().getActionId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mergeActionList)) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            mergeActionList.stream().forEach(action -> action.setOperateAuthoredUser(authoredUser));
        }
        HttpEntity httpEntity = new HttpEntity(mergeActionList, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
        return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    private void addLang(HttpHeaders headers) {
        headers.add("locale", LocaleContextHolder.getLocale().toString());
    }

    static String appendTraceInfo(String url, SubmitExecuteContext executeContext, String actionId) {
        if (StringUtils.isEmpty((Object)url)) {
            return url;
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (executeContext != null) {
            if (executeContext.getTmActivityId() != null) {
                stringBuilder.append(String.format("&TmActivityId=%s", executeContext.getTmActivityId()));
            }
            if (executeContext.getBacklogId() != null) {
                stringBuilder.append(String.format("&BacklogId=%s", executeContext.getBacklogId()));
            }
            if (executeContext.getAuthoredUser() != null) {
                stringBuilder.append(String.format("&author=%s-%s", executeContext.getAuthoredUser().getTenantId(), executeContext.getAuthoredUser().getUserId()));
            }
            if (executeContext.getProcessSerialNumber() != null) {
                stringBuilder.append(String.format("&processSerialNumber=%s", executeContext.getProcessSerialNumber()));
            }
        }
        if (actionId != null) {
            stringBuilder.append(String.format("&actionId=%s", actionId));
        }
        if (stringBuilder.length() > 0) {
            if (url.contains("?")) {
                return url + stringBuilder.substring(1);
            }
            return url + "?" + stringBuilder.substring(1);
        }
        return url;
    }

    @Override
    public void markRecycleRecordExpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        String uri = this.getAtdmUri() + "api/atdm/v1/recycle/state/expired";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)recycleRecordStateChangeDTO, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void markRecycleRecordUnexpired(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        String uri = this.getAtdmUri() + "api/atdm/v1/recycle/state/unexpired";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)recycleRecordStateChangeDTO, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void markRecycleRecordDeleted(RecycleRecordStateChangeDTO recycleRecordStateChangeDTO) {
        String uri = this.getAtdmUri() + "api/atdm/v1/recycle/state/deleted";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)recycleRecordStateChangeDTO, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO>(){}, new Object[0]);
        ((BaseResultDTO)respEntity.getBody()).getResponseWithException("");
    }

    @Override
    public BaseResultDTO<JSONObject> getDataByAction(QueryDataByActionVO queryDataByActionVO) {
        String url = this.getAtdmUri() + "api/atdm/v1/data/query/by/action";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((Object)queryDataByActionVO, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<JSONObject>>(){}, new Object[0]);
        return (BaseResultDTO)responseEntity.getBody();
    }

    @Override
    public List<Map> submitReturnTask(List<SubmitActionDTO> mergeActionList) {
        if (org.apache.commons.collections.CollectionUtils.isEmpty(mergeActionList)) {
            return new ArrayList<Map>();
        }
        if (mergeActionList.get(0) == null) {
            throw new IllegalArgumentException("submitAction.getAction()");
        }
        String uri = this.getAtdmUri() + "api/atdm/v1/action/submit/returnTask";
        uri = AtdmServiceImpl.appendTraceInfo(uri, mergeActionList.get(0).getAction().getExecuteContext(), mergeActionList.get(0).getAction().getActionId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        if (org.apache.commons.collections.CollectionUtils.isNotEmpty(mergeActionList)) {
            AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
            mergeActionList.stream().forEach(action -> action.setOperateAuthoredUser(authoredUser));
        }
        HttpEntity httpEntity = new HttpEntity(mergeActionList, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
        return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    @Override
    public QueryResultSet getResultSet(Map map, AuthoredUser authoredUser) {
        Map executeContext = (Map)map.get("executeContext");
        String actionId = null;
        String tmActivityId = executeContext.get("tmActivityId").toString();
        Long backlogId = Long.parseLong(executeContext.get("backlogId").toString());
        Map taskWithBacklogData = (Map)executeContext.get("taskWithBacklogData");
        String processSerialNumber = taskWithBacklogData.get("processSerialNumber").toString();
        Map dataSourceSet = (Map)map.get("dataSourceSet");
        List dataSourceList = (List)dataSourceSet.get("dataSourceList");
        if (!dataSourceList.isEmpty()) {
            actionId = ((Map)dataSourceList.get(0)).get("actionId").toString();
        }
        SubmitExecuteContext submitExecuteContext = new SubmitExecuteContext();
        submitExecuteContext.setAuthoredUser(authoredUser);
        submitExecuteContext.setTmActivityId(tmActivityId);
        submitExecuteContext.setBacklogId(backlogId);
        submitExecuteContext.setProcessSerialNumber(processSerialNumber);
        String url = this.getAtdmUri() + "api/atdm/v1/data/query/by/backlog/withmetadata";
        url = AtdmServiceImpl.appendTraceInfo(url, submitExecuteContext, actionId);
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HashMap body = new HashMap();
        body.put("dataSourceSetDTO", map.get("dataSourceSet"));
        body.put("executeContext", map.get("executeContext"));
        body.put("parameter", map.get("parameter"));
        body.put("dataViewQuery", null);
        HttpEntity requestEntity = new HttpEntity(body, (MultiValueMap)headers);
        ResponseEntity apiResultDTO = this.restTemplate.exchange(url, HttpMethod.POST, requestEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<QueryResultSet>>(){}, new Object[0]);
        QueryResultSet queryResultSet = (QueryResultSet)((BaseResultDTO)apiResultDTO.getBody()).getResponseWithException("");
        Map<String, List<QueryResult>> group = queryResultSet.getQueryResults().stream().collect(Collectors.groupingBy(QueryResult::getDataSourceName));
        for (Map.Entry<String, List<QueryResult>> groupItem : group.entrySet()) {
            List<QueryResult> resultList;
            if ("".equals(groupItem.getKey()) || (resultList = groupItem.getValue()).size() <= 1) continue;
            QueryResult qr = resultList.get(0);
            for (int i = 1; i < resultList.size(); ++i) {
                qr.getData().addAll(resultList.get(i).getData());
                qr.getDataKeyIndex().putAll(resultList.get(i).getDataKeyIndex());
                if (CollectionUtils.isEmpty(qr.getDataKeys()) && CollectionUtils.isNotEmpty(resultList.get(i).getDataKeys())) {
                    qr.setDataKeys(resultList.get(i).getDataKeys());
                }
                queryResultSet.getQueryResults().remove(resultList.get(i));
            }
        }
        return queryResultSet;
    }

    @Override
    public List<Map> mergeTaskRetry(MergeSubmitActionDTO mergeSubmitAction) {
        if (Objects.isNull(mergeSubmitAction.getActionMerge())) {
            return new ArrayList<Map>();
        }
        if (mergeSubmitAction.getActionMerge().getActionList() == null) {
            throw new IllegalArgumentException("submitAction.getAction()");
        }
        String uri = this.getAtdmUri() + "api/atdm/v1/action/submit/mergeTaskRetry";
        uri = AtdmServiceImpl.appendTraceInfo(uri, mergeSubmitAction.getActionMerge().getActionList().get(0).getExecuteContext(), mergeSubmitAction.getActionMerge().getActionList().get(0).getActionId());
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        this.addLang(headers);
        HttpEntity httpEntity = new HttpEntity((Object)mergeSubmitAction, (MultiValueMap)headers);
        ResponseEntity responseEntity = this.restTemplate.exchange(uri, HttpMethod.POST, httpEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<List<Map>>>(){}, new Object[0]);
        return (List)((BaseResultDTO)responseEntity.getBody()).getResponseWithException("");
    }

    @Override
    public void clearCache(Long size) {
        String url = this.getAtdmUri() + "api/atdm/v1/cache/reset?size={size}";
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());
        HashMap<String, Long> param = new HashMap<String, Long>();
        param.put("size", size);
        HttpEntity reqEntity = new HttpEntity(null, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.GET, reqEntity, (ParameterizedTypeReference)new ParameterizedTypeReference<BaseResultDTO<Object>>(){}, param);
        if (200 != respEntity.getStatusCodeValue() || !((BaseResultDTO)respEntity.getBody()).isOK()) {
            throw ErrorCodeEnum.ATMC_REMOVE_CACHE_FAIL.getBusinessException(JsonUtils.objectToString((Object)respEntity.getBody()));
        }
    }
}

