/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.atmc.http.restful.emc.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.log.LogDto;
import com.digiwin.athena.appcore.util.ExceptionUtil;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.ErrorCodeEnum;
import com.digiwin.athena.atmc.http.domain.message.EmailWithTemplateMsgDO;
import com.digiwin.athena.atmc.http.domain.message.MessageDO;
import com.digiwin.athena.atmc.http.restful.emc.SendEmailService;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

@Service
public class SendEmailServiceImpl
implements SendEmailService {
    private static final Logger log = LoggerFactory.getLogger(SendEmailServiceImpl.class);
    @Autowired
    private EnvProperties envProperties;
    @Autowired
    private RestTemplate restTemplate;

    @Override
    public void sendEmail(JSONObject content) {
        AuthoredUser authoredUser = this.getContextAuthoredUser();
        log.info("[SendEmail] SendEmailService start: {}", (Object)content);
        log.info("[SendEmail] userId: {}, tenantId: {}, token: {}", new Object[]{authoredUser.getUserId(), authoredUser.getTenantId(), authoredUser.getToken()});
        String url = this.envProperties.getEmcUri() + "/api/emc/v1/message/email";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity((Object)content, (MultiValueMap)headers);
        ResponseEntity respEntity = this.restTemplate.exchange(url, HttpMethod.POST, httpEntity, HashMap.class, new Object[0]);
        Object code = ((HashMap)respEntity.getBody()).get("code");
        Object success = ((HashMap)respEntity.getBody()).get("success");
        try {
            if (!this.requestSuccess(code, success)) {
                log.error("{}, \u8c03\u7528emc\u53d1\u9001\u90ae\u4ef6\u5931\u8d25\uff0c{}, {}", new Object[]{ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrCode(), ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrMsg(), "status code: 200, code: " + code + ", message: " + JsonUtils.objectToString(((HashMap)respEntity.getBody()).get("message"))});
                throw ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getBusinessException();
            }
        }
        catch (Exception ex) {
            throw ExceptionUtil.wrap((String)ErrorCodeEnum.EMC_V1_MESSAGE_EMAIL_FAIL.getErrCode(), (Exception)ex);
        }
    }

    private AuthoredUser getContextAuthoredUser() {
        if (null != AppAuthContextHolder.getContext().getAuthoredUser()) {
            return AppAuthContextHolder.getContext().getAuthoredUser();
        }
        return AppAuthContextHolder.getContext().getProxyAuthoredUser();
    }

    @Override
    public void sendEmailWithTemplate(String templateId, String contacts, Map emailData, MessageDO message) {
        EmailWithTemplateMsgDO msgDO = new EmailWithTemplateMsgDO();
        msgDO.setTemplateId(templateId);
        msgDO.setContacts(contacts);
        JSONObject emailMsg = new JSONObject();
        emailMsg.put((Object)"data", (Object)emailData);
        msgDO.setMessage(emailMsg);
        if (ObjectUtils.isNotEmpty((Object)message) && !StringUtils.isEmpty((CharSequence)message.getFileId())) {
            msgDO.setFileIds(Collections.singletonList(message.getFileId()));
            msgDO.setDmcBucket(message.getDmcBucket());
        }
        this.sendEmailWithTemplate(msgDO);
    }

    @Override
    public void sendEmailWithTemplate(EmailWithTemplateMsgDO msgDO) {
        JSONObject emailJson = new JSONObject();
        emailJson.put((Object)"eventId", (Object)msgDO.getTemplateId());
        emailJson.put((Object)"message", (Object)msgDO.getMessage());
        emailJson.put((Object)"contacts", (Object)msgDO.getContacts());
        if (!CollectionUtils.isEmpty(msgDO.getFileIds())) {
            emailJson.put((Object)"dmcAttachments", msgDO.getFileIds());
        }
        if (!StringUtils.isEmpty((CharSequence)msgDO.getDmcBucket())) {
            emailJson.put((Object)"dmcBucket", (Object)msgDO.getDmcBucket());
        }
        log.info("[sendEmailWithTemplate emailJson]:{}", (Object)emailJson);
        LogDto logDto = new LogDto("\u5f00\u59cb\u53d1\u9001\u90ae\u4ef6\uff0c\u6a21\u677fid:{}", msgDO.getTemplateId());
        log.info(logDto.toString());
        this.sendEmail(emailJson);
    }

    private boolean requestSuccess(Object code, Object success) {
        if (null == code || null == success) {
            return false;
        }
        return StringUtils.equals((CharSequence)String.valueOf(code), (CharSequence)String.valueOf(200)) && Boolean.valueOf(String.valueOf(success)) != false;
    }
}

