package com.digiwin.athena.atmc.http.constant;

/**
 * @Author wuzq
 * @Date 2023/6/8 10:16
 * @Description: ptm API
 * @Version 1.0
 */
public class PtmApiConstant {
    private PtmApiConstant() {
    }
    /**
     * 查询进行中的任务概要信息（项目id、项目名称，附属的任务id、任务名称等）
     */
    public static final String V_2_PROJECT_CARD_PROCESSING_LIST = "v2/api/project/card/processing/list";

    /**
     * 查询进行中的任务概要信息（任务id、任务名称等）
     */
    public static final String V_2_API_TASK_CARD_PROCESSING_LIST = "v2/api/task/card/processing/list";

    /**
     * 查询ptm项目卡列表
     */
    public static final String PROJECT_CARD_PROCESSING_LIST = "api/project/card/processing/list";
    public static final String PROJECT_CARD_PROCESSING_SIMPLIFY_LIST = "api/project/card/processing/simplifyList";

    /**
     * 查询ptm项目卡的来源和去向
     */
    public static final String PROJECT_CARD_TRACE_LIST = "api/project/card/trace/list";

    /**
     * 查询ptm任务卡的来源和去向
     */
    public static final String Task_CARD_TRACE_LIST = "api/task/card/trace/list";

    /**
     * 获取 项目卡 详情
     */
    public static final String PROJECT_CARD_DETAIL_ID_PROJECT_CARD_ID = "api/project/card/detail?id={projectCardId}";

    /**
     * 获取项目卡中指定任务的所有任务信息
     */
    public static final String PROJECT_CARD_DETAIL = "api/project/card/detail";

    /**
     * 获取 项目卡 路线
     */
    public static final String PROJECT_CARD_ROUTES_PROJECT_CARD_ID_PROJECT_CARD_ID = "api/project/card/routes?projectCardId={projectCardId}";

    /**
     * 获取 项目 的路线列表
     */
    public static final String PROJECT_ROUTES_ID_PROJECT_ID = "api/project/routes?id={projectId}";

    /**
     * 获取 指定项目ID 指定任务路线 的任务数据
     */
    public static final String PROJECT_CARD_ROUTE_TASKS = "api/project/card/route-tasks";

    /**
     * 设置默认路线
     */
    public static final String PROJECT_CARD_ROUTE_SELECTED_ID_DEFAULT_ROUTE_ID = "api/project/card/route/selected?id={defaultRouteId}";

    /**
     * 查询ptm任务卡列表
     */
    public static final String TASK_CARD_PROCESSING_LIST = "api/task/card/processing/list";
    /**
     * 查询ptm任务卡列表，abt使用
     */
    public static final String TASK_CARD_PROCESSING_SIMPLIFY_LIST = "api/task/card/processing/simplifyList";

    /**
     * 根据项目任务信息获取进行中的任务列表
     */
    public static final String TASK_CARD_TASK_BY_CONDITION_LIST = "api/task/card/task-by-condition/list";

    /**
     * 根据backlogId获取全部的任务列表
     */
    public static final String TASK_CARD_TASK_LIST_BACKLOG_ID_BACKLOG_ID = "api/task/card/task/list?backlogId={backlogId}";

    /**
     * 根据backlogId获取全部的任务列表
     */
    public static final String TASK_CARD_TASK_LIST_BATCH = "api/task/card/task/list/batch";

    /**
     * 转派 项目卡
     */
    public static final String PROJECT_CARD_REASSIGN = "api/project/card/reassign";

    /**
     * 转派 待办
     */
    public static final String TASK_CARD_REASSIGN = "api/task/card/reassign";

    /**
     * 获取项目卡记录详情（ptm_project_card表）
     */
    public static final String DATA_PROJECT_CARD_ID_PROJECT_CARD_ID = "api/data/project/card?id={projectCardId}";

    /**
     * 批量 获取项目卡 记录详情（ptm_project_card表）
     */
    public static final String DATA_PROJECT_CARD_LIST = "api/data/project/card/list";

    /**
     * 批量 获取项目卡 记录详情（ptm_project_card表）
     */
    public static final String DATA_PROJECT_CARD_LIST_BY_CONDITION = "api/data/project/card/list-by-condition";

    /**
     * 批量 获取项目卡 记录详情（ptm_project_card表）
     */
    public static final String V_2_DATA_SUB_PROJECT_CARD_LIST_BY_CONDITION = "v2/api/data/sub-project-card/list-by-condition";

    /**
     * 批量-获取指定项目卡中最近一次项目记录<br>
     * 不含data数据
     */
    public static final String PROJECT_CARD_PROCESSING_LATEST_PROJECT_BATCH = "api/project/card/processing/latest-project/batch";

    /**
     * 获取项目记录详情(ptm_project表)
     */
    public static final String DATA_PROJECT_ID_PROJECT_ID = "api/data/project?id={projectId}";

    /**
     * 批量-获取项目 记录详情(ptm_project表)
     */
    public static final String DATA_PROJECT_LIST = "api/data/project/list";

    /**
     * 获取任务记录详情(ptm_task表)
     */
    public static final String DATA_TASK_ID_TASK_ID = "api/data/task?id={taskId}";

    /**
     * 批量 获取任务记录详情(ptm_task表)
     */
    public static final String DATA_TASK_LIST = "api/data/task/list";

    /**
     * 获取活动记录详情(ptm_activity表)
     */
    public static final String DATA_TASK_ACTIVITY_ID_ACTIVITY_ID = "api/data/task/activity?id={activityId}";

    /**
     * 批量 获取活动记录详情(ptm_activity表)
     */
    public static final String DATA_TASK_ACTIVITY_LIST = "api/data/task/activity/list";

    /**
     * 获取事项的记录详情(ptm_task_activity_item 表记录)
     */
    public static final String DATA_TASK_ACTIVITY_ITEM_ID_WORK_ITEM_ID = "api/data/task/activity/item?id={workItemId}";

    /**
     * 批量 获取事项 的记录详情(ptm_task_activity_item 表记录)
     */
    public static final String DATA_TASK_ACTIVITY_ITEM_LIST = "api/data/task/activity/item/list";

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     */
    public static final String TASK_CARD_PREVIOUS_ITEM = "api/task/card/previous/item";

    /**
     * 获取指定工作项 被发起退回重签或重办的 工作项，可能为null
     */
    public static final String TASK_CARD_PREVIOUS_ITEM_BY_BACKLOG_ID = "api/task/card/previous/item/byBacklogId";

    /**
     * 获取待办的记录详情(ptm_backlog 表记录)
     */
    public static final String DATA_TASK_ACTIVITY_ITEM_BACKLOG_ID_BACKLOG_ID = "api/data/task/activity/item/backlog?id={backlogId}";

    /**
     * 批量 获取待办的记录详情(ptm_backlog 表记录)
     */
    public static final String DATA_TASK_ACTIVITY_ITEM_BACKLOG_LIST = "api/data/task/activity/item/backlog/list";

    /**
     * 根据待办id获取任务卡的data、stateData
     */
    public static final String TASK_CARD_DATA = "api/task/card/data";
    /**
     * 根据待办id获取任务卡的data、stateData
     */
    public static final String TASK_CARD_DATA_STATE_UPDATE = "api/task/card/data-state/update";

    /**
     * 更新 data 数据
     */
    public static final String TASK_CARD_DATA_UPDATE = "api/task/card/data/update";

    /**
     * 数据转派-更新 bpmData
     */
    public static final String BUSINESS_EXECUTE_ACTION = "api/business/execute/{action}";

    /**
     * 获取指人员的项目卡的最后一次更新时间
     */
    public static final String PROJECT_CARD_PROCESSING_LATEST_TIME_USER_ID_USER_ID = "api/project/card/processing/latest-time?userId={userId}";

    /**
     * 获取指定人员的待办的最后一次更新时间
     */
    public static final String TASK_CARD_PROCESSING_LATEST_TIME_USER_ID_USER_ID = "api/task/card/processing/latest-time?userId={userId}";

    /**
     * 多元交互-创建外部厂商个人租户待办
     */
    public static final String TASK_CARD_CROSS_TENANT_ADD = "api/task/card/cross-tenant/add";

    /**
     * 创建辅助执行者-待办
     */
    public static final String TASK_CARD_ASSIST_ADD = "api/task/card/assist/add";

    /**
     * 批量更新项目基本信息
     */
    public static final String DATA_PROJECT_UPDATE = "api/data/project/update";

    /**
     * 批量更新任务基本信息
     */
    public static final String DATA_TASK_UPDATE = "api/data/task/update";

    /**
     * 根据流程序号，关闭其所在的主项目。提前结束项目
     */
    public static final String PROJECT_CARD_CLOSE = "api/project/card/close";

    /**
     * 批量终止任务
     */
    public static final String TASK_CARD_TERMINATE = "api/task/card/terminate";

    /**
     * 批量根据ptm_task.id查询所属的待办部分信息
     */
    public static final String TASK_BACKLOG_LIST = "api/task/backlog/list";

    /**
     * PTM 项目型报表
     */
    public static final String TASK_CARD_ITEM_REPORT = "api/task/card/item/report";

    /**
     * 查询项目下任务的业务数据
     */
    public static final String TASK_CARD_PROJECT_REPORT = "api/task/card/project/report";

    /**
     * 根据异常排除待办id获取新发起项目的 所有的任务列表
     */
    public static final String TASK_CARD_SOLVE_TASK_LIST = "api/task/card/solve/task-list";

    /**
     * 更新签核通知信息
     */
    public static final String TASK_CARD_APPROVE_INFORMER_UPDATE = "api/task/card/approve/informer/update";

    /**
     * 获取 知会通知信息
     */
    public static final String TASK_CARD_APPROVE_INFORMER = "api/task/card/approve/informer";

    /**
     * 获取待办的签核历程
     */
    public static final String TASK_CARD_SIGN_PROCESS_BACKLOG_ID_BACKLOG_ID = "api/task/card/sign/process?backlogId={backlogId}";

    /**
     * 获取待办的签核历程
     */
    public static final String V_2_BACKLOG_SIGN_PROCESS_BACKLOG_ID_BACKLOG_ID = "v2/api/backlog/sign/process?backlogId={backlogId}";

    /**
     * 根据workItem获取待办的签核历程
     */
    public static final String V_2_WORK_ITEM_SIGN_PROCESS_WORK_ITEM_ID = "/v2/api/workitem/approve/process?workItemId={workItemId}";

    /**
     * 根据业务数据获取待办的签核历程
     */
    public static final String V_2_WORK_ITEM_SIGN_PROCESS_DATA = "/v2/api/workitem/approve/process/by/data";

    /**
     * 根据项目id和任务code来获取发起的子项目
     */
    public static final String BUSINESS_EXECUTE_QUERY_SUB_PROJECT_BY_PROJECT_CARD_ID_TASK_CODE = "api/business/execute/query-subProject-by-projectCardId-taskCode";

    /**
     * 获取已完成的代理任务id
     */
    public static final String TASK_CARD_AGENT_BACKLOG_AGENT_PERFORM_ID_AGENT_PERFORM_ID = "api/task/card/agent/backlog?agentPerformId={agentPerformId}";

    /**
     * 获取项目卡的可视化面板数据
     */
    public static final String PROJECT_CARD_PANEL_ID_PROJECT_CARD_ID = "api/project/card/panel?id={projectCardId}";

    /**
     * 是否允许撤回
     */
    public static final String TASK_CARD_IS_TASK_WITHDRAW = "api/task/card/is-taskWithdraw";

    /**
     * 是否允许跨BK撤回
     */
    public static final String TASK_CARD_IS_TASK_WITHDRAW_CROSS_BK = "api/task/card/data/revoke/validate";

    /**
     * 批量 获取项目卡 记录详情（ptm_project_card表）
     */
    public static final String DATA_PROJECT_LIST_BY_CONDITION = "api/data/project/list-by-condition";

    /**
     * 根据项目卡Id查询所有待办
     */
    public static final String V_2_TASK_BY_PROJECT_CARD_PROJECT_CARD_ID_PROJECT_CARD_ID = "v2/api/task/by-project-card?projectCardId={projectCardId}";

    /**
     * 获取团队项目分组（用于移动端）
     */
    public static final String V_2_MOBILE_PROJECT_CARD_GROUP = "v2/api/mobile/project/card/group";

    /**
     * 获取团队任务分组（用于移动端）
     */
    public static final String V_2_MOBILE_TASK_CARD_GROUP = "v2/api/mobile/task/card/group";

    /**
     * 根据分组查询项目卡列表（用于移动端）
     */
    public static final String V_2_MOBILE_PROJECT_CARD_GROUP_LIST = "v2/api/mobile/project/card/group/list";

    /**
     * 根据分组查询任务卡列表（用于移动端）
     */
    public static final String V_2_MOBILE_TASK_CARD_GROUP_LIST = "v2/api/mobile/task/card/group/list";

    /**
     * 根据人员及查询关键字查询符合条件进行中的任务
     */
    public static final String V_2_MOBILE_PROCESSING_TASK_BY_CONDITION = "v2/api/mobile/processing/task/by-condition";

    /**
     * 根据人员及任务id查询进行中的任务信息
     */
    public static final String V_2_MOBILE_PROCESSING_TASK_BY_ID = "v2/api/mobile/processing/task/by-id";

    /**
     * 根据任务信息获取执行人
     */
    public static final String V_2_WORKITEM_PERFORMER_INFO_BY_BACKLOG_IDS = "/v2/api/workitem/performerInfo/by/backlogIds";

    /**
     * 根据活动id和任务id获取bpmdata
     */
    public static final String DATA_TASK_VARIABLES = "api/data/task/variables";

    /**
     * 获取项目下异常任务信息
     */
    public static final String V_2_TASK_EXCEPTION_ACTIVITY_LIST = "/v2/api/task/exception/activity/list";

    /**
     * 交接任务
     */
    public static final String V_2_TASK_HANDOVER = "/v2/api/task/handover";

    /**
     * 交接项目
     */
    public static final String V_2_PROJECT_CARD_HANDOVER = "/v2/api/project/card/handover/batch";

    /**
     * 根据用户id列表， 起始的待办的计划完成时间 和 截止的待办的计划完成时间 查询待办项列表
     */
    public static final String V_2_WORKITEM_LIST_BY_PERFORMER = "/v2/api/workitem/list/by/performer";

    /**
     * 判断任务是否存在转派行为（因转派产生/因转派关闭）
     */
    public static final String V_2_WORKITEM_REASSIGN_OR_NOT_BACKLOG_ID_BACKLOG_ID = "/v2/api/workitem/reassign-or-not?backlogId={backlogId}";

    /**
     * 获取转派历程
     */
    public static final String V_2_WORKITEM_REASSIGN_TRACE_BACKLOG_ID_BACKLOG_ID = "/v2/api/workitem/reassign/trace?backlogId={backlogId}";

    /**
     * 查询ptm任务卡列表
     */
    public static final String V_2_BACKLOG_LIST = "/v2/api/backlog/list";

    /**
     * 根据taskId获取ptmWorkItem列表
     */
    public static final String V_2_WORKITEM_BY_TASK_ID_TASK_ID_TASK_ID = "/v2/api/workitem/by-taskId?taskId={taskId}";

    /**
     * 根据taskId等信息删除bpmdata
     */
    public static final String V_2_TASK_ACTIVITY_REMOVE_DATA = "/v2/api/task/activity/remove-data";

    /**
     * 根据任务id、活动code查询待办id(需求:9733)
     */
    public static final String V_2_BACKLOG_IDS_BY_CONDITION = "/v2/api/backlog/ids/by-condition";

    /**
     * 查询指定任务的签核历程
     */
    public static final String V_2_TASK_APPROVE_PROCESS = "/v2/api/task/approve/process";

    /**
     * 获取任务记录详情(ptm_task表)
     */
    public static final String V_2_PROJECT_TASK_ACTIVITY_BY_WORK_ITEM_ID_WORK_ITEM_ID_WORK_ITEM_ID = "/v2/api/project/task/activity/by-workItemId?workItemId={workItemId}";

    /**
     * 根据异常排除任务id查询发起的签核任务
     */
    public static final String V_2_BACKLOG_SOLVE_TASK_LIST_BACKLOG_ID_BACKLOG_ID = "/v2/api/backlog/solve-task/list?backlogId={backlogId}";

    /**
     * 根据流程序号查询项目卡相关信息
     */
    public static final String V_2_API_PROJECT_BY_SERIAL_NUMBER = "/v2/api/project/by/serialNumber";

    /**
     * 根据流程序号删除项目卡信息
     */
    public static final String V_2_API_PROJECT_DELETE_BY_SERIAL_NUMBER = "/v2/api/project/delete/by/serialNumber";

    /**
     * 根据业务数据获取需重发line消息的待办列表
     */
    public static final String V_2_DECISION_CONSULT = "/v2/api/decision/consult";

    /**
     * 强制关闭任务卡
     */
    public static final String TASK_CARD_FORCECLOSE = "/data/taskcard/forceclose";

    /**
     * 强制项目卡
     */
    public static final String PROJECT_CARD_FORCECLOSE = "/data/projectcard/forceclose";

    /**
     * 是否允许退回
     */
    public static final String TASK_IS_TASK_RETURN = "api/task/card/isTaskReturn";


    /**
     * 根据待办id获取任务卡的data、stateData (批量)
     */
    public static final String TASK_CARD_DATA_BATCH = "v2/api/task/card/data/batch";

    /**
     *  查询常规卡片所对应的辅助执行人，跨租户的卡片backlogId
     */
    public static final String V_2_DERIVE_CARDS = "/api/task/card/derive-cards";

    /**
     *  根据事项id查询转派或者交接记录
     */
    public static final String V_2_WORK_ITEM_REASSIGN_HANDOVER_TRACE = "/v2/api/workitem/reassign/handover/trace?fromWorkItemId={fromWorkItemId}&traceType={traceType}";

    /**
     * 批量 获取项目 记录详情（ptm_project表）
     */
    public static final String V_2_DATA_SUB_PROJECT_LIST_BY_CONDITION = "v2/api/data/sub-project/list-by-condition";

    /**
     * 根据项目id和任务code来获取发起的子项目
     */
    public static final String BUSINESS_EXECUTE_QUERY_SUB_PROJECT_BY_PROJECT_CARD_ID_TASK_CODE_V2 = "api/business" +
            "/execute/query-subProject-by-projectCardId-taskCode-v2";
}
