package com.digiwin.athena.atmc.http.restful.aam.impl;

import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.AamApiConstant;
import com.digiwin.athena.atmc.http.domain.misc.DemoItemResultDTO;
import com.digiwin.athena.atmc.http.restful.aam.AamService;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @Author wuzq
 * @Date 2023/6/13 9:22
 * @Description: 附件中心
 * @Version 1.0
 */
@Slf4j
@Service
public class AamServiceImpl implements AamService {

    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    MessageUtils messageUtils;

    /**
     * 重置附件数据
     */
    @Override
    public DemoItemResultDTO resetAAMData(){

        DemoItemResultDTO result = new DemoItemResultDTO();
        result.setSuccess(true);
        result.setItem("AAM 清除数据");
        result.setStartTime(LocalDateTime.now());
        result.setMessage(new ArrayList<>());
        List<String> msgList = result.getMessage();

        try {
            String uri = getAamUri() + AamApiConstant.MISC_DEMO_RESET;
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);

            ResponseEntity<Map> r = restTemplate.getForEntity(uri, Map.class);
            if(!r.getBody().containsKey("status") || !Objects.equals(r.getBody().get("status"), 200)){
                msgList.add("AAM 清除数据 出现异常，详情查看日志");
                result.setSuccess(false);
                log.error("[AAM 清除数据]", r.getBody());
            }
        }catch (Exception ex){
            result.setSuccess(false);
            msgList.add("AAM 清除数据 出现异常，详情查看日志");
            msgList.add(ex.getMessage());
            log.error("[AAM 清除数据]", ex);
        }

        result.setEndTime(LocalDateTime.now());
        return result;

    }

    private String getAamUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getAamUri();

    }


}
