package com.digiwin.athena.atmc.http.restful.asa.impl;

import cn.hutool.json.JSONObject;
import com.alibaba.fastjson.JSON;
import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.AsaApiConstant;
import com.digiwin.athena.atmc.http.restful.asa.AsaRService;
import com.digiwin.athena.atmc.http.restful.asa.model.AsaBacklogDTO;
import com.digiwin.athena.atmc.http.restful.asa.model.AsaProjectDTO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/**
 * @Description
 * @Author cai chao
 * @Date 2024/4/16 19:49
 */
@Slf4j
@Service
public class AsaRServiceImpl implements AsaRService {
    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private EnvProperties envProperties;

    @Override
    public void ptmMqMessageReceiveAsa(AsaBacklogDTO asaBacklogDTO) {
        //请求地址
        String url = envProperties.getAsaUri() + AsaApiConstant.COLLECT_CAPACITY_CREATE;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        headers.add(GlobalConstant.IAM_USER_TOKEN, AppAuthContextHolder.getContext().getAuthoredUser().getToken());

        HttpEntity<AsaBacklogDTO> httpEntity = new HttpEntity<>(asaBacklogDTO, headers);
        log.info("AsaRServiceImpl.ptmMqMessageReceiveAsa.asaBacklogDTO:{}", asaBacklogDTO);
        ResponseEntity<JSONObject> response = restTemplate.postForEntity(url, httpEntity, JSONObject.class);
        log.info("AsaRServiceImpl.ptmMqMessageReceiveAsa.result:{}", response);

    }

    @Override
    public void ptmMqProjectMessageReceiveAsa(AsaProjectDTO asaProjectDTO, AuthoredUser user) {
        //请求地址
        String url = envProperties.getAsaUri() + AsaApiConstant.ASA_ATMC_DISTRIBUTE;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        //获取列表时，传当前token，如果使用代理token，获取的就是代理token的列表
        headers.add(GlobalConstant.IAM_USER_TOKEN,user.getToken());

        HttpEntity<AsaProjectDTO> httpEntity = new HttpEntity<>(asaProjectDTO, headers);
        log.info("AsaRServiceImpl.ptmMqProjectMessageReceiveAsa.httpEntity:{}", JSON.toJSONString(httpEntity));
        try {
            ResponseEntity<JSONObject> response = restTemplate.postForEntity(url, httpEntity, JSONObject.class);
            log.info("AsaRServiceImpl.ptmMqProjectMessageReceiveAsa.result:{}", response);
        }catch (Exception e){
            log.error("AsaRServiceImpl.ptmMqProjectMessageReceiveAsa error:{}",e);
        }
    }
}
