package com.digiwin.athena.atmc.http.restful.asa.model;

import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * @Description
 * @Author cai chao
 * @Date 2024/4/16 19:54
 */
@Data
public class AsaBacklogDTO {

    private Long backlogId;
    /**
     * 待办的目标租户
     */
    private String tenantId;
    private Long projectCardId;
    private Long projectId;

    /**
     * 相当于 bpmActivity.Id
     */
    private Long taskId;

    /**
     * 相当于 bpmActivityStep.id
     */
    private Long activityId;

    /**
     * 相当于 bpmActivityWorkitem.id
     */
    private Long workItemId;
    private String performerId;
    private String performerName;
    private Boolean closed;
    private LocalDateTime planEndTime;

    private String taskDefCode;
    private String taskDefName;

    private String taskName;

    private LocalDateTime createTime;
    private LocalDateTime closedTime;
    private LocalDateTime startTime;

    /**
     * 是否是合并的工作项
     */
    private Boolean merge;

    /**
     * 处理者类型0:默认;1:辅助执行者;2:跨租户
     */
    private Integer type;

    /**
     * 来源类型
     */
    private String sourceType;

    /**
     * 通道
     */
    private List<String> channel;

    /**
     * 操作类型
     */
    private String ptmMqOperation;
}
