package com.digiwin.athena.atmc.http.restful.audc;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.http.restful.audc.model.FunctionPermissionDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TaskTypeQueryDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesAccessibleDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.UserTrackExtendDTO;

import java.util.List;
import java.util.Map;

/**
 * @author：SYQ
 * @date：2022/1/11
 */
public interface AudcService {
    /**
     * 根据租户清除数据
     * @Author：SYQ
     * @Date：2022/1/11 18:23
     */
    Map<String,Object> deleteByTenantId(AuthoredUser authoredUser, String tenantId);

    /**
     * 清除缓存
     */
    void clearCache();

    /**
     * 获取用户作业权限
     * @param authoredUser
     * @param typeActivitiesList
     * @return
     */
    List<TypeActivitiesAccessibleDTO> checkAccessActivity(AuthoredUser authoredUser, List<TypeActivitiesDTO> typeActivitiesList);

    /**
     * 获取应用权限
     * @param authoredUser
     * @return
     */
    List<FunctionPermissionDTO> checkUserAppAccess(AuthoredUser authoredUser,String appCode);

    void reportUserTrack(AuthoredUser authoredUser, List<UserTrackExtendDTO> list);

    /**
     * 查询被代理人不可被代理的任务类型
     *
     * @param authoredUser
     * @param userIdList 被代理人
     * @return
     */
    List<TaskTypeQueryDTO> queryPrincipalTaskType(AuthoredUser authoredUser, List<String> userIdList);
}
