package com.digiwin.athena.atmc.http.restful.audc.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.http.constant.AudcApiConstant;
//import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.audc.model.FunctionPermissionDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.UserTrackExtendDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TaskTypeQueryDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.digiwin.athena.atmc.http.restful.audc.AudcService;
import com.digiwin.athena.atmc.http.restful.audc.model.FunctionPermissionDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesAccessibleDTO;
import com.digiwin.athena.atmc.http.restful.audc.model.TypeActivitiesDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.github.pagehelper.util.StringUtil;
import com.google.common.collect.Lists;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

/**
 * @author：SYQ
 * @date：2022/1/11
 */
@Slf4j
@Service
public class AudcServiceImpl implements AudcService {
    @Autowired
    EnvProperties envProperties;

    @Autowired
    RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    @Override
    public Map<String, Object> deleteByTenantId(AuthoredUser authoredUser, String tenantId) {
        //结果
        Map<String, Object> resultMap = new HashMap<>();
        //租户id不能为空
        if (StringUtil.isEmpty(tenantId)) {
            return resultMap;
        }

        String uri = getAudcUri() + AtmcStrUtil.format(AudcApiConstant.COFW_DELETE_BY_TENANT_TENANT_ID, tenantId);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());

        HttpEntity<?> httpEntity = new HttpEntity<>(headers);
        try {
            ResponseEntity<BaseResultDTO<Map<String, Object>>> responseEntity = restTemplate.exchange(uri, HttpMethod.GET, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map<String, Object>>>() {
                    });
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                resultMap = responseEntity.getBody().getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), responseEntity);
            }
        } catch (Exception e) {
            log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), e.getMessage());
        }
        return resultMap;
    }

    private String getAudcUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getAudcUri();

    }


    /**
     * 清除缓存
     */
    @Override
    public void clearCache() {
        String url = getAudcUri() + AudcApiConstant.CACHE_RESET;
        HttpHeaders headers = new HttpHeaders();
        headers.add("locale", LocaleContextHolder.getLocale().toString());

        HttpEntity<BaseResultDTO<Object>> reqEntity = new HttpEntity<>(null, headers);
        ResponseEntity<BaseResultDTO<Object>> respEntity = restTemplate.exchange(url, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<BaseResultDTO<Object>>() {
        });
        // 请求失败，直接抛出异常
        respEntity.getBody().getResponseWithException("");
    }

    @Override
    public List<TypeActivitiesAccessibleDTO> checkAccessActivity(AuthoredUser authoredUser, List<TypeActivitiesDTO> typeActivitiesList) {
        //结果
        List<TypeActivitiesAccessibleDTO> resultList = Lists.newArrayList();
        //租户id不能为空
        if (CollectionUtils.isEmpty(typeActivitiesList)) {
            return resultList;
        }

        String uri = getAudcUri() + "/api/audc/v1/check/activity/accessible";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());

        HttpEntity<?> httpEntity = new HttpEntity<>(JsonUtils.objectToString(typeActivitiesList), headers);
        try {
            ResponseEntity<BaseResultDTO<List<TypeActivitiesAccessibleDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<TypeActivitiesAccessibleDTO>>>() {
                    });
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                resultList = Objects.requireNonNull(responseEntity.getBody()).getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), responseEntity);
            }
        } catch (Exception e) {
            log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), e.getMessage());
        }
        return resultList;
    }

    @Override
    public List<FunctionPermissionDTO> checkUserAppAccess(AuthoredUser authoredUser, String appCode) {
        //结果
        List<FunctionPermissionDTO> resultList = Lists.newArrayList();

        String uri = getAudcUri() + "/api/audc/v1/user/authored/app/permission/appCode?appCode=" + appCode;
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());

        try {
            HttpEntity<BaseResultDTO<List<FunctionPermissionDTO>>> reqEntity = new HttpEntity<>(null, headers);
            ResponseEntity<BaseResultDTO<List<FunctionPermissionDTO>>> respEntity = restTemplate.exchange(uri, HttpMethod.GET, reqEntity, new ParameterizedTypeReference<BaseResultDTO<List<FunctionPermissionDTO>>>() {
            });
            // 请求失败，直接抛出异常
            if (respEntity.getStatusCode() == HttpStatus.OK) {
                resultList = Objects.requireNonNull(respEntity.getBody()).getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), reqEntity);
            }
        } catch (Exception e) {
            log.error(messageUtils.getMessage("exception.audc.delete.snapshot.fail"), e.getMessage());
        }
        return resultList;
    }

    /**
     * 查询被代理人不可被代理的任务类型
     *
     * @param authoredUser
     * @param userIdList
     * @return
     */
    @Override
    public List<TaskTypeQueryDTO> queryPrincipalTaskType(AuthoredUser authoredUser, List<String> userIdList) {
        //结果
        List<TaskTypeQueryDTO> resultList = Lists.newArrayList();
        // 被代理人id不能为空
        if (CollectionUtils.isEmpty(userIdList)) {
            return resultList;
        }
        Map<String, Object> param = new HashMap();
        param.put("thePrincipalId", userIdList);
        String uri = envProperties.getAudcUri() + "/api/audc/v1/the/principal/taskDefCodes/query";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());

        HttpEntity<?> httpEntity = new HttpEntity<>(param, headers);
        try {
            ResponseEntity<BaseResultDTO<List<TaskTypeQueryDTO>>> responseEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<List<TaskTypeQueryDTO>>>() {
                    });
            if (responseEntity.getStatusCode() == HttpStatus.OK) {
                resultList = Objects.requireNonNull(responseEntity.getBody()).getResponse();
            } else {
                log.error(messageUtils.getMessage("exception.audc.query.taskDefCodes.fail"), responseEntity);
            }
        } catch (Exception e) {
            log.error(messageUtils.getMessage("exception.audc.query.taskDefCodes.fail"), e.getMessage());
        }
        return resultList;
    }
    /**
     * 埋点
     *
     * @param authoredUser
     * @param list
     */
    @Override
    public void reportUserTrack(AuthoredUser authoredUser, List<UserTrackExtendDTO> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        String uri = getAudcUri() + "/api/v1/user/track/report";
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add("token", authoredUser.getToken());
        try {
            HttpEntity<?> httpEntity = new HttpEntity<>(JsonUtils.objectToString(list), headers);
            ResponseEntity<com.digiwin.athena.appcore.domain.BaseResultDTO<Object>> respEntity = restTemplate.exchange(uri, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<com.digiwin.athena.appcore.domain.BaseResultDTO<Object>>() {
            });
            // 请求失败，直接抛出异常
            if (respEntity.getStatusCode() == HttpStatus.OK) {
                Objects.requireNonNull(respEntity.getBody()).getResponse();
            } else {
                log.error("exception.audc.report.userTrack.fail", httpEntity);
            }
        } catch (Exception e) {
            log.error("exception.audc.report.userTrack.fail", e.getMessage());
        }
    }
}
