package com.digiwin.athena.atmc.http.restful.audc.model;

import lombok.EqualsAndHashCode;
import lombok.Getter;
import lombok.NoArgsConstructor;
import lombok.Setter;
import lombok.ToString;

/**
 * UserTrackExtendDTO Description
 *
 * @author majianfu
 * @date 2021/9/2
 * @since
 */
@Getter
@Setter
@ToString(callSuper = true)
@EqualsAndHashCode(callSuper = true)
@NoArgsConstructor
public class UserTrackExtendDTO extends UserTrackDTO {
    /**
     * 记录的落表时间-时间戳
     */
    private Long createDate;

    /**
     * 记录的落表时间-格式化后的字符串
     */
    private String createDateStr;

    /**
     * 利用雪花生成的唯一ID
     */
    private Long uniqueId;

    /**
     * 客户端id，方便FI关联前后上报行为上报，计算耗时等
     */
    private String clientId;

    /**
     * 来源（大小写不敏感）：
     * performance_analysis : 性能分析
     * function_analysis : 功能分析
     * null : 用户行为上报
     */
    private String source;

    private String sessionId;

    public String printInfo() {
        return new StringBuilder()
                .append(this.getTenantId())
                .append(":")
                .append(this.getUserId())
                .append(":")
                .append(this.getWorkCode())
                .append(":")
                .append(this.getOperation())
                .append(":")
                .append(this.getTimestamp())
                .append(":")
                .append(this.getSource())
                .append("::")
                .toString();
    }
}
