package com.digiwin.athena.atmc.http.restful.im.impl;

import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.appcore.util.MessageUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;
import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.http.constant.ImApiConstant;
//import com.digiwin.athena.atmc.http.env.EnvProperties;
import com.digiwin.athena.atmc.http.restful.im.ImService;
import com.digiwin.athena.atmc.http.restful.im.model.TeamMemberInfoDTO;
import com.digiwin.athena.atmc.http.util.AtmcStrUtil;
import com.digiwin.athena.atmc.http.restful.im.model.IMSendMessageDTO;
import com.digiwin.athena.atmc.http.restful.im.model.ImNeteaseUserDTO;
import com.jugg.agile.biz.digiwin.config.biz.DwBizConfig;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.*;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import java.util.*;

/**
 * ImServiceImpl Description
 *
 * @author majianfu
 * @date 2021/7/10
 * @since
 */
@Slf4j
@Service
public class ImServiceImpl implements ImService {

    @Resource
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Autowired
    private MessageUtils messageUtils;

    private boolean disableIM() {
        return StringUtils.isBlank(getImUri());
    }
    /**
     * {@inheritDoc}
     */
    @Override
    public List<TeamMemberInfoDTO> queryTeamMembers(Long tid) {
        String url = getImUri() + AtmcStrUtil.format(ImApiConstant.TEAM_GET_TEAM_MEMBERS_TID, tid) ;
        ResponseEntity<BaseResultDTO<List<TeamMemberInfoDTO>>> respEntity = restTemplate.exchange(url, HttpMethod.GET, null, new ParameterizedTypeReference<BaseResultDTO<List<TeamMemberInfoDTO>>>() {
        });
        return respEntity.getBody().getResponseWithException(messageUtils.getMessage("exception.im.get.team.members.fail"));
    }

    private String getImUri() {
        return DwBizConfig.AaskDomainConfig.Sai.getImUri();
    }


    /**
     * {@inheritDoc}
     */
    @Override
    public void pushMessage(String token, IMSendMessageDTO messageDTO) {
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, token);
        String url = getImUri() + ImApiConstant.PUSH;
        HttpEntity<IMSendMessageDTO> httpEntity = new HttpEntity<>(messageDTO, headers);
        ResponseEntity<BaseResultDTO<Void>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity, new ParameterizedTypeReference<BaseResultDTO<Void>>() {
        });
        respEntity.getBody().getResponseWithException("");
    }

    /**
     * 批量根据userId获取IM 网易云信账号
     * @param userIdList
     * @return
     */
    @Override
    public List<ImNeteaseUserDTO> queryNeteaseUsers(List<String> userIdList){
        List<ImNeteaseUserDTO> result = new ArrayList<>();

        //请求地址
        String url = getImUri() + ImApiConstant.USER_GET_USER_INFO_BY_USER_IDS;
        //头部
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);

        Map condition = new HashMap();
        condition.put("userIds", userIdList);

        //入参
        HttpEntity<?> httpEntity = new HttpEntity<>(condition, headers);
        //请求接口
        ResponseEntity<BaseResultDTO<List<ImNeteaseUserDTO>>> responseEntity = null;
        responseEntity = restTemplate.exchange(url, HttpMethod.POST,httpEntity,new ParameterizedTypeReference<BaseResultDTO<List<ImNeteaseUserDTO>>>(){}, condition);

        if(responseEntity.getBody().isOK() && responseEntity.getBody().getResponse()!=null) {
            result = responseEntity.getBody().getResponse();
        }
        return result;
    }

    /**
     * 关闭群（用于atmc）
     * @Author：SYQ
     * @Date：2021/6/16 11:13
     */
    public void removeTeam(String bizId, int type, AuthoredUser user){
        // 禁用IM
        if(disableIM()) {
            return;
        }

        try {
            //获取用户信息
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
            //获取当前用户是否开启代理以及代理人地址
            String url = getImUri() + ImApiConstant.TEAM_REMOVE_TEAM;
            //查询参数
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("bizId", bizId);
            paramMap.put("type", type);
            paramMap.put("source","atmc");
            HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
            //调用接口
            ResponseEntity<Map> response = restTemplate.postForEntity(url, httpEntity, Map.class);

        }catch (Exception e){
            log.error(e.getMessage(),e);
        }
    }

    /**
     * 修改群信息
     * @Author：SYQ
     * @Date：2021/10/25 15:28
     */
    public void updateTeamInfo(AuthoredUser user,String tid,String cardIds){
        // 禁用IM
        if(disableIM()) {
            return;
        }
        Map resultMap = null;
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        //接口地址
        String url = getImUri() + ImApiConstant.TEAM_UPDATE_TEAM;
        //请求参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("tid",tid);
        paramMap.put("cardIds",cardIds);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap,headers);
        //调用接口
        ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url,httpEntity, Map.class);
        log.info("更新群消息：{}",responseEntity);
    }

    /**
     * 添加群成员
     * @Author：SYQ
     * @Date：2021/6/10 17:20
     */
    public void addTeamMembers(AuthoredUser user,String bizId,int type,List<String> memberList){
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        //接口地址
        String url = getImUri() + ImApiConstant.TEAM_ADD_MEMBERS;
//        String url = "http://192.168.8.203:8081/team/addMembers";
        //请求参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bizId",bizId);
        paramMap.put("type",type);
        paramMap.put("memberIds",memberList);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap,headers);
        //调用接口
        ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url,httpEntity, Map.class);
        System.out.println(responseEntity);
    }

    /**
     * 创建群
     * @Author：SYQ
     * @Date：2021/6/10 17:14
     */
    public void createTeam(AuthoredUser user,String owner,String teamName,String bizId,int type,
                            int ifMaster,int visiable,List<String> memberList,String pId,
                            List<Map> externalAccounts,List<Map> externalEocMembers,String businessKey){
        if(memberList != null && memberList.size() > 0){
            memberList.removeIf(s -> StringUtils.isEmpty(s));
        }
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        //接口地址
        String url = getImUri() + ImApiConstant.TEAM_CREATE_ASYNC;
//        String url = "http://192.168.8.203:8081/team/create";
        //请求参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("owner",owner);
        paramMap.put("teamName",teamName);
        paramMap.put("bizName",teamName);
        paramMap.put("bizId",bizId);
        paramMap.put("type",type);
        paramMap.put("ifMaster",ifMaster);
        paramMap.put("visible",visiable);
        paramMap.put("memberIds",memberList);
        paramMap.put("pId",pId);
        paramMap.put("source","atmc");
        if(externalAccounts != null && externalAccounts.size() > 0){
            paramMap.put("externalAccounts",externalAccounts);
        }
        if(externalEocMembers != null && externalEocMembers.size() > 0){
            paramMap.put("externalEocMembers",externalEocMembers);
        }
        paramMap.put("businessKey",businessKey);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap,headers);
        //调用接口
        ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url,httpEntity, Map.class);
        System.out.println(responseEntity);
    }

    /**
     * 获取群信息
     * @Author：SYQ
     * @Date：2021/10/25 15:28
     */
    public Map getTeamInfo(AuthoredUser user,String bizId,int type,String source){
        // 禁用IM
        if(disableIM()) {
            return null;
        }
        Map resultMap = null;
        //获取用户信息
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
        //接口地址
        String url = getImUri() + ImApiConstant.TEAM_GET_MASTER_BY_BIZ_ID_AND_TYPE_AND_SOURCE;
        //请求参数
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("bizId",bizId);
        paramMap.put("type",type);
        paramMap.put("source",source);
        HttpEntity<?> httpEntity = new HttpEntity<>(paramMap,headers);
        //调用接口
        ResponseEntity<Map> responseEntity = restTemplate.postForEntity(url,httpEntity, Map.class);
        if(responseEntity.getStatusCode() == HttpStatus.OK){
            Object response = responseEntity.getBody().get("response");
            if(response != null && response != ""){
                resultMap = JsonUtils.jsonToObject(JsonUtils.objectToString(response),Map.class);
            }
        }
        return resultMap;
    }

    /**
     * 根据租户清除数据
     * @Author：SYQ
     * @Date：2022/1/10 16:22
     */
    public Map<String,Integer> clearDataByTenantSid(AuthoredUser user){
        Map<String,Integer> resultMap = new HashMap<>();
        try{
            // 禁用IM
            if(disableIM()) {
                return resultMap;
            }
            //获取用户信息
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
            //接口地址
            String url = getImUri() + AtmcStrUtil.format(ImApiConstant.TEAM_CLEAR_DATA_BY_TENANT_SID_TENANT_SID, user.getTenantSid());;

            //请求参数
            HttpEntity<?> httpEntity = new HttpEntity<>(headers);
            //调用接口
            ResponseEntity<Map> responseEntity = restTemplate.exchange(url, HttpMethod.GET, httpEntity, Map.class);
            if(responseEntity != null && responseEntity.getStatusCode() == HttpStatus.OK){
                resultMap.put("code",200);
                log.info("根据租户清除IM数据成功！");
            }else{
                resultMap.put("code",500);
            }
        }catch (Exception e){
            resultMap.put("code",500);
            log.error("根据租户清除IM数据失败：{}", e.getMessage());
        }
        return resultMap;
    }

    /**
     * 批量解散群(用于pcc)
     * @Author：SYQ
     * @Date：2021/11/1 17:54
     */
    public void removeTeamByParam(String bizId,int type,String cardId,String businessKey,AuthoredUser user){
        // 禁用IM
        if(disableIM()) {
            return;
        }
        try {
            //获取用户信息
            HttpHeaders headers = new HttpHeaders();
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.add(GlobalConstant.IAM_USER_TOKEN, user.getToken());
            //获取当前用户是否开启代理以及代理人地址
            String url = getImUri() + ImApiConstant.TEAM_REMOVE_TEAM;
            //查询参数
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("bizId", bizId);
            paramMap.put("type", type);
            paramMap.put("cardId", cardId);
            paramMap.put("businessKey",businessKey);
            paramMap.put("source","pcc");
            HttpEntity<?> httpEntity = new HttpEntity<>(paramMap, headers);
            log.info("批量解散群：{}",paramMap);
            //调用接口
            ResponseEntity<Map> response = restTemplate.postForEntity(url, httpEntity, Map.class);
            log.info("批量解散群成功：{}",response);
        }catch (Exception e){
            log.error("批量解散群失败：{}",e);
        }
    }

}
