package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;

/**
 * PTM 项目卡详情 的项目卡数据
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class PtmProjectCardDetailDTO {

    private Long id;
    private String projectCardName;
    private String projectDefName;
    private String projectDefCode;
    private String tenantId;
    private Boolean hidden;
    private LocalDateTime startTime;
    private LocalDateTime endTime;
    private LocalDateTime createTime;
    private LocalDateTime updatedTime;
    private Map businessUnit;
    private String sourceName;
    private String personInCharge;
    private String personInChargeName;
    private String engineType;
    private Integer changedProjectCount;
    private Integer changedProjectId;
    private List<ProjectDTO> projects;

    @Data
    @AllArgsConstructor
    @NoArgsConstructor
    @Builder
    public static class ProjectDTO {
        private Long projectId;
        private String projectName;
        private String eocCode;
        private String eocName;
        private Integer eocType;
        private String sourceIds;
        private LocalDateTime createTime;
        private Integer emergency;
        private Map businessUnit;
    }
}
