package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.time.LocalDateTime;
import java.util.Date;
import java.util.List;

/**
 * PTM 项目卡列表 的项目卡数据
 */
@Data
public class PtmProjectCardITraceDTO {
    /**
     * 项目卡id
     */
    private Long id;

    /**
     * 原执行人id
     */
    private String oldPerformerId;

    /**
     * 原执行人name
     */
    private String oldPerformerName;

    /**
     * 新执行人id
     */
    private String directionPerformerId;

    /**
     * 新执行人name
     */
    private String directionPerformerName;

    /**
     * 和PTM保持一致   项目只有 1、3
     * 0-任务转派；1-项目转派;2-任务交接；3-项目交接
     */
    private Integer type;

    /**
     * 创建时间
     */
    private Date createTime;
}
