package com.digiwin.athena.atmc.http.restful.ptm.model;

import lombok.Data;

import java.util.Date;

/**
 * PTM 任务卡列表 的任务卡数据
 */
@Data
public class PtmTaskCardITraceDTO {
    /**
     * 任务卡id
     */
    private Long id;

    /**
     * 原执行人id
     */
    private String oldPerformerId;

    /**
     * 原执行人name
     */
    private String oldPerformerName;

    /**
     * 去向执行人id
     */
    private String directionPerformerId;

    /**
     * 去向执行人name
     */
    private String directionPerformerName;

    /**
     * 任务卡状态
     *   0  正常新增
     *   1  轉派新增
     *   2  退回重簽
     *   3  退回重辦
     *   4  加簽
     *   9  撤回重辦
     *   10  交接新增
     *
     *   99 终止（在ptm自定义的枚举 用来标识终止）
     */
    private Integer type;

    /**
     * 卡片去向状态
     */
    private Integer directionState;

    /**
     * 创建时间
     */
    private Date createTime;
}
