package com.digiwin.athena.atmc.http.restful.semc.impl;

import com.digiwin.athena.appcore.auth.AppAuthContextHolder;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.appcore.domain.BaseResultDTO;
import com.digiwin.athena.appcore.util.JsonUtils;
import com.digiwin.athena.atmc.application.configuration.EnvProperties;


import com.digiwin.athena.atmc.core.meta.constants.GlobalConstant;
import com.digiwin.athena.atmc.http.restful.semc.TddService;
import com.digiwin.athena.atmc.http.restful.semc.model.EncryptedConfigDTO;
import com.digiwin.athena.atmc.http.restful.semc.model.EncryptedConfigVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

import java.util.HashMap;
import java.util.Map;

/**
 * @author mk
 * @date 2024/10/19 15:32
 * @description: 智能入口数据获取
 */
@Slf4j
@Service
public class TddServiceImpl implements TddService {

    @Autowired
    private EnvProperties envProperties;

    @Autowired
    private RestTemplate restTemplate;

    @Override
    public EncryptedConfigVO getEncryptedConfig(EncryptedConfigDTO encryptedConfigDTO) {

        AuthoredUser authoredUser = AppAuthContextHolder.getContext().getAuthoredUser();
        String url = envProperties.getTddUri() + "/encrypted/getEncryptedConfig";
        try {
            HttpHeaders headers = new HttpHeaders();
            headers.add(GlobalConstant.IAM_USER_TOKEN, authoredUser.getToken());
            HttpEntity requestEntity = new HttpEntity<>(encryptedConfigDTO,headers);
            ResponseEntity<BaseResultDTO<EncryptedConfigVO>> resultDTOResponseEntity = restTemplate.exchange(url, HttpMethod.POST, requestEntity,
                    new ParameterizedTypeReference<BaseResultDTO<EncryptedConfigVO>>() {
                    });
            return resultDTOResponseEntity.getBody().getResponseWithException("");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return null;
        }
    }

    @Override
    public String makePassword(Integer passwordStreflgth, Integer passwordLength) {
        String url = envProperties.getTddUri() + "/encrypted/makePassword";

        Map<String, Object> params = new HashMap<>();
        params.put("defenceComplexity", passwordStreflgth);
        params.put("defenceLength", passwordLength);

        HttpHeaders headerMap = new HttpHeaders();
        headerMap.setContentType(MediaType.APPLICATION_JSON);
        HttpEntity httpEntity = new HttpEntity(params, headerMap);
        try {
            ResponseEntity<BaseResultDTO<Map>> respEntity = restTemplate.exchange(url, HttpMethod.POST, httpEntity,
                    new ParameterizedTypeReference<BaseResultDTO<Map>>() {
                    });
            Map response = respEntity.getBody().getResponseWithException("");
            if (response.containsKey("defence")) {
                return response.get("defence") + "";
            }
        } catch (Exception ex) {
            log.error("[queryRowDataAttachmentList] body: {}, error: ", JsonUtils.objectToString(params), ex);
        }
        return null;
    }
}
