package com.digiwin.athena.atmc.http.restful.semc.model;

import lombok.Data;

/**
 * @author mk
 * @date 2024/10/19 15:48
 * @description:
 */
@Data
public class EncryptedConfigVO {

    /**
     * 应用 code
     */
    private String appCode;

    /**
     * 分类 code
     */
    private String categoryCode;

    /**
     * 基础资料/报表/项目/任务 code
     */
    private String itemCode;

    /**
     * 使用场景
     */
    private Sice sice;

    /**
     * 生效范围
     */
    private Scope scope;

    /**
     * 加密规则
     */
    private Rule rule;

    /**
     * 加密规则
     */
    private Scene scene;

    /**
     * 启停用状态, 0: 停用，1: 启用
     */
    private Integer status;

    @Data
    public static class Sice{
        /**
         * 下载
         */
        private Boolean download;

        /**
         * 导出
         */
        private Boolean export;
    }

    @Data
    public static class Scope{
        /**
         * 内部员工
         */
        private Boolean internalEmployee;

        /**
         * 外部员工
         */
        private Boolean externalEmployee;
    }

    @Data
    public static class Rule{
        /**
         * 密码复杂度
         */
        private Integer defenceComplexity;

        /**
         * 密码位数
         */
        private Integer defenceLength;
    }

    @Data
    public static class Scene{
        /**
         * 下载
         */
        private Boolean download;

        /**
         * 附件
         */
        private Boolean attachment;
    }

}
