package com.digiwin.athena.atmc.presentation.server.web.backlog;

import com.digiwin.athena.appcore.auth.GlobalConstant;
import com.digiwin.athena.appcore.auth.domain.AuthoredUser;
import com.digiwin.athena.atmc.application.dto.request.TodoBackLogNumReq;
import com.digiwin.athena.atmc.application.dto.response.task.TaskCardResp;
import com.digiwin.athena.atmc.application.configuration.BacklogAsyncConfig;
import com.digiwin.athena.atmc.application.service.query.backlog.BpmTodoBacklogQueryCountingQryService;
import com.digiwin.athena.atmc.application.service.query.backlog.TodoBacklogQueryCountingQryService;
import com.digiwin.athena.atmc.core.meta.concurrent.pool.DynamicThreadPool;
import com.digiwin.athena.atmc.presentation.common.controller.BaseController;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.*;

@RestController
@RequestMapping(value = "/api/atmc/v1/backlog")
@Slf4j
public class BacklogQueryController extends BaseController {


    @Autowired
    private BpmTodoBacklogQueryCountingQryService bpmTodoBacklogServiceQuery;

    @Autowired
    private TodoBacklogQueryCountingQryService backlogCardQueryService;

    @Autowired
    BacklogAsyncConfig backlogAsyncConfig;


    public CompletableFuture<Void> submit(Runnable task) {
        return CompletableFuture.runAsync(task, taskExecutor);
    }


    @Autowired
    DynamicThreadPool taskExecutor;

    //直接查询size
    @GetMapping("/list/size")
    List<TaskCardResp> getBacklogList(@RequestAttribute(value = GlobalConstant.AUTH_USER, required = false) AuthoredUser user, @RequestBody @Validated TodoBackLogNumReq req) {
        log.info("[backlogList-{}-{}-{}-{}]", user.getUserId(), user.getTenantId(), req.getClientType(), req.getClientId());
        // 流程引擎
        List<TaskCardResp> backlogDTOS = new ArrayList<>();
        Runnable bpmTask =()-> backlogDTOS.addAll(bpmTodoBacklogServiceQuery.getBacklogListByTenantIdAndUserIdAndCode(user, req.getClientId()));
        CompletableFuture<Void> bpmSubmit = submit(bpmTask);

        Runnable ptmTask = ()-> backlogDTOS.addAll(backlogCardQueryService.getBacklogListByTenantIdAndUserIdAndCode(user, req.getClientId()));
        CompletableFuture<Void> ptmSubmit = submit(ptmTask);
        try {
            CompletableFuture.allOf(bpmSubmit, ptmSubmit).get(backlogAsyncConfig.getTimeOut(), backlogAsyncConfig.getTimeUnit());
        } catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }

        return backlogDTOS;
    }

}
