/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.api.interceptor;

import com.digiwin.athena.bpm.resource.MessageResourceUtils;
import java.util.Locale;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ApiAccessInterceptor
implements MethodInterceptor {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        try {
            if (Objects.nonNull(RequestContextHolder.getRequestAttributes())) {
                HttpServletRequest httpServletRequest = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
                String locale = httpServletRequest.getHeader("locale");
                if (StringUtils.isNotEmpty((CharSequence)locale)) {
                    MessageResourceUtils.setLocale(locale);
                } else {
                    MessageResourceUtils.setLocale(new Locale("en", "US"));
                }
            }
            Object object = methodInvocation.proceed();
            return object;
        }
        finally {
            MessageResourceUtils.removeLocaleContext();
        }
    }
}

