/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.api.interceptor;

import com.digiwin.app.service.restful.DWPathVariable;
import com.digiwin.athena.bpm.api.ApiLogService;
import com.digiwin.athena.bpm.api.interceptor.ApiLog;
import com.digiwin.athena.bpm.api.model.ApiLogDTO;
import com.digiwin.athena.bpm.common.util.DateUtils;
import com.digiwin.athena.bpm.common.util.SpringContextUtil;
import java.lang.reflect.Parameter;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class ApiLogInterceptor
implements MethodInterceptor {
    public Object invoke(MethodInvocation methodInvocation) throws Throwable {
        Object result = null;
        long duration = 0L;
        long timestamp = System.currentTimeMillis();
        Date startDate = DateUtils.getDateTimeNow();
        Exception exception = null;
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        try {
            Parameter[] mParameters = methodInvocation.getMethod().getParameters();
            Object[] mArguments = methodInvocation.getArguments();
            int mArgumentsLength = mArguments.length;
            for (int i = 0; i < mParameters.length; ++i) {
                DWPathVariable annotation = mParameters[i].getDeclaredAnnotation(DWPathVariable.class);
                if (Objects.nonNull(annotation)) continue;
                if (i < mArgumentsLength) {
                    parameters.put(mParameters[i].getName(), mArguments[i]);
                    continue;
                }
                parameters.put(mParameters[i].getName(), null);
            }
            result = methodInvocation.proceed();
            duration = System.currentTimeMillis() - timestamp;
        }
        catch (Throwable throwable) {
            exception = new Exception(throwable);
            throw throwable;
        }
        finally {
            ApiLog annotation;
            if (duration == 0L) {
                duration = System.currentTimeMillis() - timestamp;
            }
            if (Objects.nonNull(annotation = methodInvocation.getMethod().getDeclaredAnnotation(ApiLog.class))) {
                this.saveApiLog(parameters, result, startDate, DateUtils.getDateTimeNow(), duration, exception);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveApiLog(Map<String, Object> parameters, Object result, Date sDate, Date eDate, long duration, Exception exception) {
        ApiLogDTO apiLogDTO = new ApiLogDTO();
        apiLogDTO.setStartTime(sDate);
        apiLogDTO.setEndTime(eDate);
        apiLogDTO.setDuration(duration);
        try {
            HttpServletRequest httpServletRequest = ((ServletRequestAttributes)Objects.requireNonNull(RequestContextHolder.getRequestAttributes())).getRequest();
            apiLogDTO.setUri(httpServletRequest.getRequestURI());
            String url = httpServletRequest.getRequestURL().toString();
            if (!StringUtils.isEmpty((CharSequence)httpServletRequest.getQueryString())) {
                url = url + "?" + httpServletRequest.getQueryString();
            }
            apiLogDTO.addRequest("url", url);
            apiLogDTO.addRequest("method", httpServletRequest.getMethod());
            HashMap<String, String> headers = new HashMap<String, String>();
            Enumeration headerNames = httpServletRequest.getHeaderNames();
            while (headerNames.hasMoreElements()) {
                String element = (String)headerNames.nextElement();
                if (null == element) continue;
                headers.put(element, httpServletRequest.getHeader(element));
            }
            apiLogDTO.addRequest("header", headers);
            if (parameters.size() == 1) {
                apiLogDTO.addRequest("body", parameters.values().toArray()[0]);
            } else {
                apiLogDTO.addRequest("body", parameters);
            }
            apiLogDTO.setStatus(200);
            apiLogDTO.addResponse("status", 200);
            apiLogDTO.addResponse("body", result);
            if (!Objects.isNull(exception)) {
                apiLogDTO.setStatus(500);
                apiLogDTO.addResponse("status", 500);
                apiLogDTO.addResponse("errorMessage", ExceptionUtils.getStackTrace((Throwable)exception));
            }
        }
        catch (Exception ex) {
            String errorMessage = ExceptionUtils.getStackTrace((Throwable)ex);
            apiLogDTO.addResponse("errorMessageLog", errorMessage);
        }
        finally {
            SpringContextUtil.getBean("apiLogService", ApiLogService.class).save(apiLogDTO);
        }
    }
}

