/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.api.model;

import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.bpm.common.util.GsonUtils;
import com.digiwin.athena.bpm.common.util.JsonUtils;
import java.io.Serializable;
import org.apache.commons.lang3.StringUtils;

public class ApiErrorModel
implements Serializable {
    private String code;
    private String errorCode;
    private String errorMessage;
    private String appId;
    private String domain;
    private String uri;
    private Object request;
    private Object response;
    private String reqId;
    private Object description;

    public ApiErrorModel() {
    }

    public ApiErrorModel(String code, String errorCode, String errorMessage, String appId, String domain, String uri, Object request, Object response, String reqId, Object description) {
        this.code = code;
        this.errorCode = errorCode;
        this.errorMessage = errorMessage;
        this.appId = appId;
        this.domain = domain;
        this.uri = uri;
        this.request = request;
        this.response = response;
        this.reqId = reqId;
        this.description = description;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public String getAppId() {
        return this.appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public Object getResponse() {
        return this.response;
    }

    public void setResponse(Object response) {
        this.response = response;
    }

    public String getReqId() {
        return this.reqId;
    }

    public void setReqId(String reqId) {
        this.reqId = reqId;
    }

    public Object getDescription() {
        return this.description;
    }

    public void setDescription(Object description) {
        this.description = description;
    }

    public String toString() {
        return JsonUtils.toJson(this);
    }

    public static ApiErrorModelBuilder builder() {
        return new ApiErrorModelBuilder();
    }

    public static class ApiErrorModelBuilder {
        private String code;
        private String errorCode;
        private String errorMessage;
        private String appId;
        private String domain;
        private String uri;
        private Object request;
        private Object response;
        private String reqId;
        private Object description;

        public ApiErrorModelBuilder code(String code) {
            this.code = code;
            return this;
        }

        public ApiErrorModelBuilder errorCode(String errorCode) {
            this.errorCode = errorCode;
            return this;
        }

        public ApiErrorModelBuilder errorMessage(String errorMessage) {
            this.errorMessage = errorMessage;
            return this;
        }

        public ApiErrorModelBuilder appId(String appId) {
            this.appId = appId;
            return this;
        }

        public ApiErrorModelBuilder domain(String domain) {
            this.domain = domain;
            return this;
        }

        public ApiErrorModelBuilder uri(String uri) {
            this.uri = uri;
            return this;
        }

        public ApiErrorModelBuilder request(Object request) {
            this.request = request;
            return this;
        }

        public ApiErrorModelBuilder response(Object response) {
            this.response = response;
            return this;
        }

        public ApiErrorModelBuilder reqId(String reqId) {
            this.reqId = reqId;
            return this;
        }

        public ApiErrorModelBuilder description(Object description) {
            this.description = description;
            return this;
        }

        public ApiErrorModel build() {
            if (StringUtils.isEmpty((CharSequence)this.code)) {
                this.code = "500";
            }
            if (StringUtils.isEmpty((CharSequence)this.errorCode)) {
                this.code = "UNKNOWN";
            }
            return new ApiErrorModel(this.code, this.errorCode, this.errorMessage, this.appId, this.domain, this.uri, this.request, this.response, this.reqId, this.description);
        }

        public DWException buildDWException() {
            return this.buildDWException(this.errorCode);
        }

        public DWException buildDWException(String errCode) {
            return new DWException(errCode, this.toString());
        }

        public String toString() {
            return GsonUtils.toJson(this);
        }
    }
}

