/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.serializer.date;

import com.digiwin.athena.bpm.common.serializer.date.DateFormatStyle;
import com.digiwin.athena.bpm.common.serializer.date.DateRegex;
import com.digiwin.athena.bpm.common.util.DateUtils;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import java.io.IOException;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;

public class DateCommonDeserializer
extends JsonDeserializer<Date> {
    public Date deserialize(JsonParser p, DeserializationContext deserializationContext) throws IOException {
        return DateCommonDeserializer.formatToDate(p.getValueAsString());
    }

    private static boolean isCST(String valueString) {
        String[] dateArray = valueString.split(" ");
        return dateArray.length > 5 && Arrays.stream(DateRegex.WEEKS).anyMatch(s -> Objects.equals(s, dateArray[0])) && DateRegex.isOK(dateArray[3], DateRegex.HMS_END_SECOND_PATTERN) && dateArray[5].length() == 4;
    }

    public static Date formatToDate(String valueString) {
        if (StringUtils.isBlank((CharSequence)valueString)) {
            return null;
        }
        if (DateRegex.isOK(valueString, DateRegex.BAR_END_SECOND_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.BAR_END_SECOND);
        }
        if (DateRegex.isOK(valueString, DateRegex.SLASH_END_SECOND_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.SLASH_END_SECOND);
        }
        if (DateRegex.isOK(valueString, DateRegex.BAR_END_MINUTE_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.BAR_END_MINUTE);
        }
        if (DateRegex.isOK(valueString, DateRegex.SLASH_END_MINUTE_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.SLASH_END_MINUTE);
        }
        if (DateRegex.isOK(valueString, DateRegex.STRING_END_SECOND_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.STRING_END_SECOND);
        }
        if (DateRegex.isOK(valueString, DateRegex.STRING_END_MINUTE_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.STRING_END_MINUTE);
        }
        if (DateRegex.isOK(valueString, DateRegex.BAR_END_DAY_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.BAR_END_DAY);
        }
        if (DateRegex.isOK(valueString, DateRegex.SLASH_END_DAY_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.SLASH_END_DAY);
        }
        if (DateRegex.isOK(valueString, DateRegex.STRING_END_DAY_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.STRING_END_DAY);
        }
        if (DateRegex.isOK(valueString, DateRegex.BAR_END_MS_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.BAR_END_MS);
        }
        if (DateRegex.isOK(valueString, DateRegex.SLASH_END_MS_PATTERN)) {
            return DateUtils.formatToDate(valueString, DateFormatStyle.SLASH_END_MS);
        }
        if (DateCommonDeserializer.isCST(valueString)) {
            return DateUtils.parseTimeZone(valueString, DateFormatStyle.CST_FORMAT, Locale.US);
        }
        return null;
    }
}

