/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.util;

import com.digiwin.athena.bpm.common.serializer.date.DateFormatStyle;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class DateUtils {
    private static final Pattern DATE_BASIC_PATTERN = Pattern.compile("(((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])|(((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9])|(((19|20)[0-9]{2})-(0?[1-9]|1[012])-(0?[1-9]|[12][0-9]|3[01]))|(((19|20)[0-9]{2})/(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9]:[0-5][0-9])|(((19|20)[0-9]{2})/(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01]) ([01]?[0-9]|2[0-3]):[0-5][0-9])|(((19|20)[0-9]{2})/(0?[1-9]|1[012])/(0?[1-9]|[12][0-9]|3[01]))|(((19|20)[0-9]{2})(0?[1-9]|1[012])(0?[1-9]|[12][0-9]|3[01])([01]?[0-9]|2[0-3])[0-5][0-9][0-5][0-9])|(((19|20)[0-9]{2})(0?[1-9]|1[012])(0?[1-9]|[12][0-9]|3[01])([01]?[0-9]|2[0-3])[0-5][0-9])|(((19|20)[0-9]{2})(0?[1-9]|1[012])(0?[1-9]|[12][0-9]|3[01]))");
    private static final Pattern DATE_BASIC_FORMAT_PATTERN = Pattern.compile("(\\d{4})-(\\d+)-(\\d+).*");

    public static Date getDateTimeNow() {
        LocalDateTime localDateTime = LocalDateTime.now();
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDate localDate) {
        return Date.from(localDate.atStartOfDay().atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date asDate(LocalDateTime localDateTime) {
        return Date.from(localDateTime.atZone(ZoneId.systemDefault()).toInstant());
    }

    public static LocalDate asLocalDate(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDate();
    }

    public static LocalDateTime asLocalDateTime(Date date) {
        return Instant.ofEpochMilli(date.getTime()).atZone(ZoneId.systemDefault()).toLocalDateTime();
    }

    public static Date nowAddByMonth(int number) {
        Calendar instance = Calendar.getInstance();
        instance.add(2, number);
        return instance.getTime();
    }

    public static Date nowMonthLast() {
        Calendar now = Calendar.getInstance();
        now.set(5, now.getActualMaximum(5));
        return now.getTime();
    }

    public static int nowMonthLastDay() {
        return Calendar.getInstance().getActualMaximum(5);
    }

    public static String formatToString(Date date, DateFormatStyle dateFormatStyle) {
        return DateUtils.formatToString(date, dateFormatStyle.getValue());
    }

    public static String formatToString(Date date, String dateStyle) {
        SimpleDateFormat format = new SimpleDateFormat(dateStyle);
        return format.format(date);
    }

    public static String formatToString(Date date) {
        return DateUtils.formatToString(date, DateFormatStyle.BAR_END_SECOND.getValue());
    }

    public static Date formatToDate(String date, String dateStyle) {
        SimpleDateFormat format = new SimpleDateFormat(dateStyle);
        try {
            return format.parse(date);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static Date formatToDate(String date, DateFormatStyle dateFormatStyle) {
        return DateUtils.formatToDate(date, dateFormatStyle.getValue());
    }

    public static Date addMonth(Date date, int number) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(2, number);
        return instance.getTime();
    }

    public static Date addSecond(Date date, int number) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(13, number);
        return instance.getTime();
    }

    public static Date addMinute(Date date, int number) {
        Calendar instance = Calendar.getInstance();
        instance.setTime(date);
        instance.add(12, number);
        return instance.getTime();
    }

    public static long getMinuteInterval(Date a, Date b) {
        return Math.abs((a.getTime() - b.getTime()) / 60000L);
    }

    public static long getDayInterval(Date a, Date b) {
        return Math.abs((a.getTime() - b.getTime()) / 86400000L);
    }

    public static boolean isDate(String inputTime) {
        Matcher matcher = DATE_BASIC_PATTERN.matcher(inputTime);
        if (!matcher.matches()) {
            return false;
        }
        matcher = DATE_BASIC_FORMAT_PATTERN.matcher(inputTime);
        if (matcher.matches()) {
            int year = Integer.parseInt(matcher.group(1));
            int month = Integer.parseInt(matcher.group(2));
            int date = Integer.parseInt(matcher.group(3));
            if (date > 28) {
                Calendar instance = Calendar.getInstance();
                instance.set(year, month - 1, 1);
                int lastDay = instance.getActualMaximum(5);
                return lastDay >= date;
            }
        }
        return true;
    }

    public static boolean isNotDate(String inputTime) {
        return !DateUtils.isDate(inputTime);
    }

    public static Date formatStringByStyle(String inputTime, String dateStyle) {
        try {
            if (StringUtils.isBlank((CharSequence)inputTime)) {
                return null;
            }
            if (StringUtils.isBlank((CharSequence)dateStyle)) {
                return null;
            }
            SimpleDateFormat format = new SimpleDateFormat(dateStyle);
            return format.parse(inputTime);
        }
        catch (ParseException e) {
            return null;
        }
    }

    public static LocalDateTime formatStringByStyleToLocalDateTime(String inputTime, String dateStyle) {
        if (StringUtils.isBlank((CharSequence)inputTime)) {
            return null;
        }
        if (StringUtils.isBlank((CharSequence)dateStyle)) {
            return null;
        }
        return LocalDateTime.parse(inputTime, DateTimeFormatter.ofPattern(dateStyle));
    }

    public static String currentTimeString() {
        return DateUtils.currentTimeString(DateFormatStyle.STRING_END_MS.getValue());
    }

    public static String currentTimeString(String dateStyle) {
        return DateUtils.formatToString(Calendar.getInstance().getTime(), dateStyle);
    }

    public static String datePath() {
        return DateUtils.currentTimeString("yyyy/MM/dd");
    }

    public static LocalDate getPreviousDay(int i) {
        LocalDate today = LocalDate.now();
        return today.minus(i, ChronoUnit.DAYS);
    }

    public static Timestamp getTimeStamp(String time, DateFormatStyle dateFormatStyle) {
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormatStyle.getValue());
        try {
            Timestamp timestamp = new Timestamp(sdf.parse(time).getTime());
            return timestamp;
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Error dateTime format of " + time + ", pattern should be '" + (Object)((Object)DateFormatStyle.BAR_END_DAY) + "'");
        }
    }

    public static Date parseTimeZone(String dateString, DateFormatStyle dateFormatStyle, Locale locale) {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormatStyle.getValue(), locale);
            return simpleDateFormat.parse(dateString);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Date getFirstDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(7) == 1) {
            calendar.add(5, -1);
        }
        calendar.add(5, calendar.getFirstDayOfWeek() - calendar.get(7) + 1);
        return calendar.getTime();
    }

    public static Date getLastDayOfWeek(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        if (calendar.get(7) == 1) {
            return date;
        }
        calendar.add(5, 7 - calendar.get(7) + 1);
        return calendar.getTime();
    }

    public static Date getLastMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.set(2, calendar.get(2) - 1);
        return calendar.getTime();
    }

    public static Date getFirstDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int last = calendar.getActualMinimum(5);
        calendar.set(5, last);
        return calendar.getTime();
    }

    public static Date getLastDayOfMonth(Date date) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        int last = calendar.getActualMaximum(5);
        calendar.set(5, last);
        return calendar.getTime();
    }
}

