/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.util;

import com.digiwin.athena.bpm.common.util.SpringContextUtil;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.springframework.data.redis.connection.DataType;
import org.springframework.data.redis.core.Cursor;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ScanOptions;
import org.springframework.data.redis.core.ZSetOperations;

public class RedisUtil {
    private RedisTemplate<String, Object> redisTemplate;

    public void setRedisTemplate(RedisTemplate<String, Object> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public RedisTemplate<String, Object> getRedisTemplate() {
        return this.redisTemplate;
    }

    public void delete(String key) {
        this.redisTemplate.delete((Object)key);
    }

    public void delete(Collection<String> keys) {
        this.redisTemplate.delete(keys);
    }

    public byte[] dump(String key) {
        return this.redisTemplate.dump((Object)key);
    }

    public Boolean hasKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }

    public Boolean expire(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.expire((Object)key, timeout, unit);
    }

    public Boolean expireAt(String key, Date date) {
        return this.redisTemplate.expireAt((Object)key, date);
    }

    public Set<String> keys(String pattern) {
        return this.redisTemplate.keys((Object)pattern);
    }

    public Boolean move(String key, int dbIndex) {
        return this.redisTemplate.move((Object)key, dbIndex);
    }

    public Boolean persist(String key) {
        return this.redisTemplate.persist((Object)key);
    }

    public Long getExpire(String key, TimeUnit unit) {
        return this.redisTemplate.getExpire((Object)key, unit);
    }

    public Long getExpire(String key) {
        return this.redisTemplate.getExpire((Object)key);
    }

    public String randomKey() {
        return (String)this.redisTemplate.randomKey();
    }

    public void rename(String oldKey, String newKey) {
        this.redisTemplate.rename((Object)oldKey, (Object)newKey);
    }

    public Boolean renameIfAbsent(String oldKey, String newKey) {
        return this.redisTemplate.renameIfAbsent((Object)oldKey, (Object)newKey);
    }

    public DataType type(String key) {
        return this.redisTemplate.type((Object)key);
    }

    public void setObject(String key, Object value) {
        this.redisTemplate.opsForValue().set((Object)key, value);
    }

    public Object getObject(String key) {
        return this.redisTemplate.opsForValue().get((Object)key);
    }

    public List<Object> getObjects(Collection<String> keys) {
        return this.redisTemplate.opsForValue().multiGet(keys);
    }

    public void set(String key, String value) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value);
    }

    public String getString(String key) {
        return String.valueOf(this.redisTemplate.opsForValue().get((Object)key));
    }

    public String getRange(String key, long start, long end) {
        return this.redisTemplate.opsForValue().get((Object)key, start, end);
    }

    public String getAndSetString(String key, String value) {
        return String.valueOf(this.redisTemplate.opsForValue().getAndSet((Object)key, (Object)value));
    }

    public Boolean getBit(String key, long offset) {
        return this.redisTemplate.opsForValue().getBit((Object)key, offset);
    }

    public List<String> multiGet(Collection<String> keys) {
        return this.redisTemplate.opsForValue().multiGet(keys).stream().map(v -> String.valueOf(v)).collect(Collectors.toList());
    }

    public boolean setBit(String key, long offset, boolean value) {
        return this.redisTemplate.opsForValue().setBit((Object)key, offset, value);
    }

    public void setEx(String key, String value, long timeout, TimeUnit unit) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, timeout, unit);
    }

    public boolean setIfAbsent(String key, String value) {
        return this.redisTemplate.opsForValue().setIfAbsent((Object)key, (Object)value);
    }

    public void setRange(String key, String value, long offset) {
        this.redisTemplate.opsForValue().set((Object)key, (Object)value, offset);
    }

    public Long size(String key) {
        return this.redisTemplate.opsForValue().size((Object)key);
    }

    public void multiSet(Map<String, String> maps) {
        this.redisTemplate.opsForValue().multiSet(maps);
    }

    public boolean multiSetIfAbsent(Map<String, String> maps) {
        return this.redisTemplate.opsForValue().multiSetIfAbsent(maps);
    }

    public Long incrBy(String key, long increment) {
        return this.redisTemplate.opsForValue().increment((Object)key, increment);
    }

    public Double incrByFloat(String key, double increment) {
        return this.redisTemplate.opsForValue().increment((Object)key, increment);
    }

    public Integer append(String key, String value) {
        return this.redisTemplate.opsForValue().append((Object)key, value);
    }

    public Object hGet(String key, String field) {
        return this.redisTemplate.opsForHash().get((Object)key, (Object)field);
    }

    public Map<Object, Object> hGetAll(String key) {
        return this.redisTemplate.opsForHash().entries((Object)key);
    }

    public List<Object> hMultiGet(String key, Collection<Object> fields) {
        return this.redisTemplate.opsForHash().multiGet((Object)key, fields);
    }

    public void hPut(String key, Object hashKey, Object value) {
        this.redisTemplate.opsForHash().put((Object)key, hashKey, value);
    }

    public void hPutAll(String key, Map<String, Object> maps) {
        this.redisTemplate.opsForHash().putAll((Object)key, maps);
    }

    public Boolean hPutIfAbsent(String key, Object hashKey, Object value) {
        return this.redisTemplate.opsForHash().putIfAbsent((Object)key, hashKey, value);
    }

    public Long hDelete(String key, Object ... fields) {
        return this.redisTemplate.opsForHash().delete((Object)key, fields);
    }

    public boolean hExists(String key, Object field) {
        return this.redisTemplate.opsForHash().hasKey((Object)key, field);
    }

    public Long hIncrBy(String key, Object field, long increment) {
        return this.redisTemplate.opsForHash().increment((Object)key, field, increment);
    }

    public Double hIncrByFloat(String key, Object field, double delta) {
        return this.redisTemplate.opsForHash().increment((Object)key, field, delta);
    }

    public Set<Object> hKeys(String key) {
        return this.redisTemplate.opsForHash().keys((Object)key);
    }

    public Long hSize(String key) {
        return this.redisTemplate.opsForHash().size((Object)key);
    }

    public List<Object> hValues(String key) {
        return this.redisTemplate.opsForHash().values((Object)key);
    }

    public Cursor<Map.Entry<Object, Object>> hScan(String key, ScanOptions options) {
        return this.redisTemplate.opsForHash().scan((Object)key, options);
    }

    public Object lIndex(String key, long index) {
        return this.redisTemplate.opsForList().index((Object)key, index);
    }

    public List<Object> lRange(String key, long start, long end) {
        return this.redisTemplate.opsForList().range((Object)key, start, end);
    }

    public Long lLeftPush(String key, Object value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, value);
    }

    public Long lLeftPushAll(String key, Object ... value) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, value);
    }

    public Long lLeftPushAll(String key, Collection<Object> value) {
        return this.redisTemplate.opsForList().leftPushAll((Object)key, value);
    }

    public Long lLeftPushIfPresent(String key, Object value) {
        return this.redisTemplate.opsForList().leftPushIfPresent((Object)key, value);
    }

    public Long lLeftPush(String key, Object pivot, Object value) {
        return this.redisTemplate.opsForList().leftPush((Object)key, pivot, value);
    }

    public Long lRightPush(String key, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, value);
    }

    public Long lRightPushAll(String key, Object ... value) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, value);
    }

    public Long lRightPushAll(String key, Collection<Object> value) {
        return this.redisTemplate.opsForList().rightPushAll((Object)key, value);
    }

    public Long lRightPushIfPresent(String key, Object value) {
        return this.redisTemplate.opsForList().rightPushIfPresent((Object)key, value);
    }

    public Long lRightPush(String key, Object pivot, Object value) {
        return this.redisTemplate.opsForList().rightPush((Object)key, pivot, value);
    }

    public void lSet(String key, long index, String value) {
        this.redisTemplate.opsForList().set((Object)key, index, (Object)value);
    }

    public Object lLeftPop(String key) {
        return this.redisTemplate.opsForList().leftPop((Object)key);
    }

    public Object lBLeftPop(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.opsForList().leftPop((Object)key, timeout, unit);
    }

    public Object lRightPop(String key) {
        return this.redisTemplate.opsForList().rightPop((Object)key);
    }

    public Object lBRightPop(String key, long timeout, TimeUnit unit) {
        return this.redisTemplate.opsForList().rightPop((Object)key, timeout, unit);
    }

    public Object lRightPopAndLeftPush(String sourceKey, String destinationKey) {
        return this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey);
    }

    public Object lBRightPopAndLeftPush(String sourceKey, String destinationKey, long timeout, TimeUnit unit) {
        return this.redisTemplate.opsForList().rightPopAndLeftPush((Object)sourceKey, (Object)destinationKey, timeout, unit);
    }

    public Long lRemove(String key, long index, Object value) {
        return this.redisTemplate.opsForList().remove((Object)key, index, value);
    }

    public void lTrim(String key, long start, long end) {
        this.redisTemplate.opsForList().trim((Object)key, start, end);
    }

    public Long lLen(String key) {
        return this.redisTemplate.opsForList().size((Object)key);
    }

    public Long sAdd(String key, Object ... values) {
        return this.redisTemplate.opsForSet().add((Object)key, values);
    }

    public Long sRemove(String key, Object ... values) {
        return this.redisTemplate.opsForSet().remove((Object)key, values);
    }

    public Object sPop(String key) {
        return this.redisTemplate.opsForSet().pop((Object)key);
    }

    public Boolean sMove(String key, Object value, String destKey) {
        return this.redisTemplate.opsForSet().move((Object)key, value, (Object)destKey);
    }

    public Long sSize(String key) {
        return this.redisTemplate.opsForSet().size((Object)key);
    }

    public Boolean sIsMember(String key, Object value) {
        return this.redisTemplate.opsForSet().isMember((Object)key, value);
    }

    public Set<Object> sIntersect(String key, String otherKey) {
        return this.redisTemplate.opsForSet().intersect((Object)key, (Object)otherKey);
    }

    public Set<Object> sIntersect(String key, Collection<String> otherKeys) {
        return this.redisTemplate.opsForSet().intersect((Object)key, otherKeys);
    }

    public Long sIntersectAndStore(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.redisTemplate.opsForSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Set<Object> sUnion(String key, String otherKeys) {
        return this.redisTemplate.opsForSet().union((Object)key, (Object)otherKeys);
    }

    public Set<Object> sUnion(String key, Collection<String> otherKeys) {
        return this.redisTemplate.opsForSet().union((Object)key, otherKeys);
    }

    public Long sUnionAndStore(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sUnionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.redisTemplate.opsForSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Set<Object> sDifference(String key, String otherKey) {
        return this.redisTemplate.opsForSet().difference((Object)key, (Object)otherKey);
    }

    public Set<Object> sDifference(String key, Collection<String> otherKeys) {
        return this.redisTemplate.opsForSet().difference((Object)key, otherKeys);
    }

    public Long sDifference(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForSet().differenceAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long sDifference(String key, Collection<String> otherKeys, String destKey) {
        return this.redisTemplate.opsForSet().differenceAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Set<Object> setMembers(String key) {
        return this.redisTemplate.opsForSet().members((Object)key);
    }

    public Object sRandomMember(String key) {
        return this.redisTemplate.opsForSet().randomMember((Object)key);
    }

    public List<Object> sRandomMembers(String key, long count) {
        return this.redisTemplate.opsForSet().randomMembers((Object)key, count);
    }

    public Set<Object> sDistinctRandomMembers(String key, long count) {
        return this.redisTemplate.opsForSet().distinctRandomMembers((Object)key, count);
    }

    public Cursor<Object> sScan(String key, ScanOptions options) {
        return this.redisTemplate.opsForSet().scan((Object)key, options);
    }

    public Boolean zAdd(String key, String value, double score) {
        return this.redisTemplate.opsForZSet().add((Object)key, (Object)value, score);
    }

    public Long zAdd(String key, Set<ZSetOperations.TypedTuple<Object>> values) {
        return this.redisTemplate.opsForZSet().add((Object)key, values);
    }

    public Long zRemove(String key, Object ... values) {
        return this.redisTemplate.opsForZSet().remove((Object)key, values);
    }

    public Double zIncrementScore(String key, String value, double delta) {
        return this.redisTemplate.opsForZSet().incrementScore((Object)key, (Object)value, delta);
    }

    public Long zRank(String key, Object value) {
        return this.redisTemplate.opsForZSet().rank((Object)key, value);
    }

    public Long zReverseRank(String key, Object value) {
        return this.redisTemplate.opsForZSet().reverseRank((Object)key, value);
    }

    public Set<Object> zRange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().range((Object)key, start, end);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeWithScores(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().rangeWithScores((Object)key, start, end);
    }

    public Set<Object> zRangeByScore(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().rangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zRangeByScoreWithScores(String key, double min, double max, long start, long end) {
        return this.redisTemplate.opsForZSet().rangeByScoreWithScores((Object)key, min, max, start, end);
    }

    public Set<Object> zReverseRange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().reverseRange((Object)key, start, end);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zReverseRangeWithScores(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().reverseRangeWithScores((Object)key, start, end);
    }

    public Set<Object> zReverseRangeByScore(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max);
    }

    public Set<ZSetOperations.TypedTuple<Object>> zReverseRangeByScoreWithScores(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().reverseRangeByScoreWithScores((Object)key, min, max);
    }

    public Set<Object> zReverseRangeByScore(String key, double min, double max, long start, long end) {
        return this.redisTemplate.opsForZSet().reverseRangeByScore((Object)key, min, max, start, end);
    }

    public Long zCount(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().count((Object)key, min, max);
    }

    public Long zSize(String key) {
        return this.redisTemplate.opsForZSet().size((Object)key);
    }

    public Long zZCard(String key) {
        return this.redisTemplate.opsForZSet().zCard((Object)key);
    }

    public Double zScore(String key, Object value) {
        return this.redisTemplate.opsForZSet().score((Object)key, value);
    }

    public Long zRemoveRange(String key, long start, long end) {
        return this.redisTemplate.opsForZSet().removeRange((Object)key, start, end);
    }

    public Long zRemoveRangeByScore(String key, double min, double max) {
        return this.redisTemplate.opsForZSet().removeRangeByScore((Object)key, min, max);
    }

    public Long zUnionAndStore(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForZSet().unionAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long zUnionAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.redisTemplate.opsForZSet().unionAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Long zIntersectAndStore(String key, String otherKey, String destKey) {
        return this.redisTemplate.opsForZSet().intersectAndStore((Object)key, (Object)otherKey, (Object)destKey);
    }

    public Long zIntersectAndStore(String key, Collection<String> otherKeys, String destKey) {
        return this.redisTemplate.opsForZSet().intersectAndStore((Object)key, otherKeys, (Object)destKey);
    }

    public Cursor<ZSetOperations.TypedTuple<Object>> zScan(String key, ScanOptions options) {
        return this.redisTemplate.opsForZSet().scan((Object)key, options);
    }

    public static RedisUtil getModuleRedisUtil() {
        return SpringContextUtil.getBean("moduleRedisUtil", RedisUtil.class);
    }

    public static RedisUtil getRedisUtil() {
        return SpringContextUtil.getBean("redisUtil", RedisUtil.class);
    }
}

