/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.configuration;

import com.digiwin.athena.bpm.common.event.LocalEventPublisher;
import com.digiwin.athena.bpm.common.util.SpringContextUtil;
import com.digiwin.gateway.token.TokenService;
import org.apache.http.client.HttpClient;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.retry.annotation.EnableRetry;
import org.springframework.scheduling.annotation.EnableAsync;
import org.springframework.web.client.RestTemplate;

@EnableRetry
@Configuration
@EnableAsync(proxyTargetClass=true)
public class ModuleAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ModuleAutoConfiguration.class);
    @Value(value="${httpClientMaxTotal:200}")
    private int maxTotal;
    @Value(value="${httpClientMaxPerRoute:100}")
    private int maxPerRoute;
    @Value(value="${httpClientRequestTimeOutMilliSecond:120000}")
    private int requestTimeOutMilliSecond;
    @Value(value="${httpClientConnectTimeOutMilliSecond:120000}")
    private int connectTimeOutMilliSecond;
    @Value(value="${httpClientSocketTimeOutMilliSecond:120000}")
    private int socketTimeOutMilliSecond;
    @Autowired(required=false)
    @Qualifier(value="dwAttemptHttpLoadbalanceRoute")
    HttpRoutePlanner httpRoutePlanner;

    @Bean
    public SpringContextUtil springContextUtil() {
        return new SpringContextUtil();
    }

    @Bean(value={"tokenService"})
    public TokenService tokenService() {
        return new TokenService();
    }

    @Bean(value={"common-restTemplate"})
    public RestTemplate restTemplate(@Qualifier(value="common-resttemplate-requestfactory") ClientHttpRequestFactory httpRequestFactory) {
        RestTemplate restTemplate = new RestTemplate(httpRequestFactory);
        return restTemplate;
    }

    @Bean(value={"common-resttemplate-requestfactory"})
    public ClientHttpRequestFactory httpRequestFactory(@Qualifier(value="dw-httpclient-request-retry-handler") HttpRequestRetryHandler requestRetryHandler, @Qualifier(value="dw-httpclient-response-retry-strategy") ServiceUnavailableRetryStrategy serviceUnavailableRetryStrategy) {
        HttpClientBuilder builder = HttpClientBuilder.create().setRetryHandler(requestRetryHandler).setServiceUnavailableRetryStrategy(serviceUnavailableRetryStrategy);
        PoolingHttpClientConnectionManager connectionManager = this.getConnectionManager();
        connectionManager.setMaxTotal(this.maxTotal);
        connectionManager.setDefaultMaxPerRoute(this.maxPerRoute);
        RequestConfig requestConfig = RequestConfig.custom().setSocketTimeout(this.socketTimeOutMilliSecond).setConnectTimeout(this.connectTimeOutMilliSecond).setConnectionRequestTimeout(this.requestTimeOutMilliSecond).build();
        builder.setDefaultRequestConfig(requestConfig).setConnectionManager((HttpClientConnectionManager)connectionManager).setRoutePlanner(this.httpRoutePlanner).build();
        CloseableHttpClient httpClient = builder.build();
        HttpComponentsClientHttpRequestFactory clientHttpRequestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        return clientHttpRequestFactory;
    }

    @Bean(value={"httpClientConnectionManager"})
    public PoolingHttpClientConnectionManager getConnectionManager() {
        return new PoolingHttpClientConnectionManager();
    }

    @Bean(value={"localEventPublisher"})
    public LocalEventPublisher localEventPublisher() {
        return new LocalEventPublisher();
    }

    @Bean(value={"httpClientConnectionManager"})
    public PoolingHttpClientConnectionManager getConnectionManger() {
        return new PoolingHttpClientConnectionManager();
    }
}

