/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.configuration;

import com.digiwin.athena.bpm.configuration.MongoBigDecimalCodec;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientSettings;
import com.mongodb.MongoClientURI;
import org.bson.codecs.Codec;
import org.bson.codecs.configuration.CodecRegistries;
import org.bson.codecs.configuration.CodecRegistry;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.mongodb.config.AbstractMongoConfiguration;
import org.springframework.data.mongodb.core.MongoTemplate;

@Configuration
public class MongoDBConfiguration
extends AbstractMongoConfiguration {
    @Value(value="${spring.data.mongodb.database}")
    private String databaseName;
    @Value(value="${spring.data.mongodb.uri}")
    private String connectionString;
    @Value(value="${spring.data.mongodb.maxConnectionIdleTime:600000}")
    private int maxConnectionIdleTime;

    @Bean(name={"mongoClient"})
    public MongoClient mongoClient() {
        MongoClientOptions.Builder builder = new MongoClientOptions.Builder();
        builder.maxConnectionIdleTime(this.maxConnectionIdleTime);
        builder.codecRegistry(MongoDBConfiguration.getMongoCodecRegistry());
        return new MongoClient(new MongoClientURI(this.connectionString, builder));
    }

    @Bean(name={"mongoTemplate"})
    public MongoTemplate mongoTemplate(MongoClient mongoClient) {
        return new MongoTemplate(mongoClient, this.databaseName);
    }

    public static CodecRegistry getMongoCodecRegistry() {
        CodecRegistry codecRegistry = MongoClientSettings.getDefaultCodecRegistry();
        MongoBigDecimalCodec bigDecimalCodec = new MongoBigDecimalCodec();
        CodecRegistry customCodecRegistry = CodecRegistries.fromCodecs((Codec[])new Codec[]{bigDecimalCodec});
        return CodecRegistries.fromRegistries((CodecRegistry[])new CodecRegistry[]{codecRegistry, customCodecRegistry});
    }

    protected String getDatabaseName() {
        return this.databaseName;
    }
}

