/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.configuration;

import com.digiwin.athena.bpm.common.serializer.RedisKeySerializer;
import com.digiwin.athena.bpm.common.util.RedisUtil;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.connection.RedisConnectionFactory;
import org.springframework.data.redis.connection.RedisPassword;
import org.springframework.data.redis.connection.RedisStandaloneConfiguration;
import org.springframework.data.redis.connection.jedis.JedisClientConfiguration;
import org.springframework.data.redis.connection.jedis.JedisConnectionFactory;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.ListOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.SetOperations;
import org.springframework.data.redis.core.ValueOperations;
import org.springframework.data.redis.core.ZSetOperations;
import org.springframework.data.redis.serializer.Jackson2JsonRedisSerializer;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.data.redis.serializer.StringRedisSerializer;
import redis.clients.jedis.JedisPoolConfig;

@Configuration
public class SpringRedisConfiguration {
    @Value(value="${spring.redis.host:localhost}")
    private String redisHost;
    @Value(value="${spring.redis.database:0}")
    private int database;
    @Value(value="${spring.redis.port:6379}")
    private int port;
    @Value(value="${spring.redis.password}")
    private String password;
    @Value(value="${spring.redis.timeout:3000}")
    private int timeout;
    @Value(value="${spring.redis.pool.max-active:1000}")
    private int maxTotal;
    @Value(value="${spring.redis.pool.max-wait:1000}")
    private long maxWait;
    @Value(value="${spring.redis.pool.max-idle:50}")
    private int maxIdle;
    @Value(value="${spring.redis.pool.min-idle:10}")
    private int minIdle;
    @Value(value="${spring.redis.pool.testOnBorrow:true}")
    private boolean testOnBorrow;
    @Value(value="${spring.redis.pool.testOnReturn:true}")
    private boolean testOnReturn;
    @Value(value="${spring.redis.keyPrefix:bpm}")
    private String keyPrefix;

    @Bean(value={"jedisPoolConfig"})
    public JedisPoolConfig jedisPoolConfig() {
        JedisPoolConfig jedisPoolConfig = new JedisPoolConfig();
        jedisPoolConfig.setMaxTotal(this.maxTotal);
        jedisPoolConfig.setMinIdle(this.minIdle);
        jedisPoolConfig.setMaxIdle(this.maxIdle);
        jedisPoolConfig.setMaxWaitMillis(this.maxWait);
        jedisPoolConfig.setTestOnBorrow(this.testOnBorrow);
        jedisPoolConfig.setTestOnReturn(this.testOnReturn);
        return jedisPoolConfig;
    }

    @Bean
    @ConditionalOnMissingBean(value={RedisConnectionFactory.class})
    public RedisConnectionFactory redisConnectionFactory(JedisPoolConfig jedisPoolConfig) {
        RedisStandaloneConfiguration redisStandaloneConfiguration = new RedisStandaloneConfiguration();
        redisStandaloneConfiguration.setHostName(this.redisHost);
        redisStandaloneConfiguration.setDatabase(this.database);
        redisStandaloneConfiguration.setPassword(RedisPassword.of((String)this.password));
        redisStandaloneConfiguration.setPort(this.port);
        JedisClientConfiguration.DefaultJedisClientConfigurationBuilder jedisPoolingClientConfigurationBuilder = (JedisClientConfiguration.DefaultJedisClientConfigurationBuilder)JedisClientConfiguration.builder();
        jedisPoolingClientConfigurationBuilder.usePooling();
        jedisPoolingClientConfigurationBuilder.poolConfig((GenericObjectPoolConfig)jedisPoolConfig);
        JedisClientConfiguration jedisClientConfiguration = jedisPoolingClientConfigurationBuilder.build();
        return new JedisConnectionFactory(redisStandaloneConfiguration, jedisClientConfiguration);
    }

    @Bean(value={"moduleRedisTemplate"})
    public RedisTemplate<String, Object> bpmRedisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return this.getRedisTemplate(redisConnectionFactory, new RedisKeySerializer(this.keyPrefix));
    }

    @Bean(value={"redisTemplate"})
    public RedisTemplate<String, Object> redisTemplate(RedisConnectionFactory redisConnectionFactory) {
        return this.getRedisTemplate(redisConnectionFactory, (RedisSerializer<String>)new StringRedisSerializer());
    }

    private RedisTemplate<String, Object> getRedisTemplate(RedisConnectionFactory redisConnectionFactory, RedisSerializer<String> redisSerializer) {
        RedisTemplate template = new RedisTemplate();
        template.setConnectionFactory(redisConnectionFactory);
        Jackson2JsonRedisSerializer jackson2JsonRedisSerializer = new Jackson2JsonRedisSerializer(Object.class);
        ObjectMapper om = new ObjectMapper();
        om.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        om.enableDefaultTyping(ObjectMapper.DefaultTyping.NON_FINAL);
        jackson2JsonRedisSerializer.setObjectMapper(om);
        template.setKeySerializer(redisSerializer);
        template.setHashKeySerializer(redisSerializer);
        template.setValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.setHashValueSerializer((RedisSerializer)jackson2JsonRedisSerializer);
        template.afterPropertiesSet();
        return template;
    }

    @Bean(value={"hashOperations"})
    public HashOperations<String, String, Object> hashOperations(RedisTemplate<String, Object> redisTemplate) {
        return redisTemplate.opsForHash();
    }

    @Bean(value={"valueOperations"})
    public ValueOperations<String, Object> valueOperations(RedisTemplate<String, Object> redisTemplate) {
        return redisTemplate.opsForValue();
    }

    @Bean(value={"listOperations"})
    public ListOperations<String, Object> listOperations(RedisTemplate<String, Object> redisTemplate) {
        return redisTemplate.opsForList();
    }

    @Bean(value={"setOperations"})
    public SetOperations<String, Object> setOperations(RedisTemplate<String, Object> redisTemplate) {
        return redisTemplate.opsForSet();
    }

    @Bean(value={"zSetOperations"})
    public ZSetOperations<String, Object> zSetOperations(RedisTemplate<String, Object> redisTemplate) {
        return redisTemplate.opsForZSet();
    }

    @Bean(value={"moduleRedisUtil"})
    public RedisUtil moduleRedisUtil(RedisConnectionFactory redisConnectionFactory) {
        RedisUtil redisUtil = new RedisUtil();
        redisUtil.setRedisTemplate(this.bpmRedisTemplate(redisConnectionFactory));
        return redisUtil;
    }

    @Bean(value={"redisUtil"})
    public RedisUtil redisUtil(RedisConnectionFactory redisConnectionFactory) {
        RedisUtil redisUtil = new RedisUtil();
        redisUtil.setRedisTemplate(this.redisTemplate(redisConnectionFactory));
        return redisUtil;
    }
}

