/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.mq;

import com.digiwin.athena.bpm.common.util.GsonUtils;
import com.digiwin.athena.bpm.common.util.IdGenerator;
import com.digiwin.athena.bpm.common.util.LoggerUtils;
import com.digiwin.athena.bpm.mq.MQMessage;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.amqp.core.Message;
import org.springframework.amqp.core.MessageProperties;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.scheduling.annotation.Async;

public class MQMessageService {
    private final RabbitTemplate rabbitTemplate;
    private final MongoTemplate mongoTemplate;

    public MQMessageService(RabbitTemplate rabbitTemplate, MongoTemplate mongoTemplate) {
        this.rabbitTemplate = rabbitTemplate;
        this.mongoTemplate = mongoTemplate;
    }

    @Async
    public void send(MQMessage mqMessage, MessageProperties messageProperties) {
        try {
            if (Objects.isNull(mqMessage.getTraceId())) {
                mqMessage.setTraceId(IdGenerator.nextRandomUUID());
            }
            messageProperties.setHeader("message-trace-id", (Object)mqMessage.getTraceId());
            messageProperties.getHeaders().forEach((k, v) -> mqMessage.addHeader((String)k, v.toString()));
            this.saveMQMessage(mqMessage);
            Object message = mqMessage.getMessage();
            byte[] body = message instanceof String ? ((String)mqMessage.getMessage()).getBytes(StandardCharsets.UTF_8) : GsonUtils.toJson(mqMessage.getMessage()).getBytes(StandardCharsets.UTF_8);
            this.rabbitTemplate.send(mqMessage.getExchangeName(), mqMessage.getRoutingKey(), new Message(body, messageProperties), new CorrelationData(mqMessage.getTraceId()));
        }
        catch (Exception exception) {
            LoggerUtils.errorTrace("MQMessageService.send.Error", "\n|*****************************************************************************\n|** exchange=" + mqMessage.getExchangeName() + "\n|** routingKey=" + mqMessage.getRoutingKey() + "\n|** message=" + mqMessage + "\n|** exception=" + exception.getMessage());
            mqMessage.setStatus(101);
            this.saveMQMessage(mqMessage);
        }
    }

    @Async
    public void send(MQMessage mqMessage, Map<String, String> headers) {
        MessageProperties messageProperties = new MessageProperties();
        if (Objects.nonNull(headers)) {
            headers.forEach((k, v) -> {
                if ("expiration".equals(k)) {
                    messageProperties.setExpiration(v);
                } else {
                    messageProperties.setHeader(k, v);
                }
            });
        }
        this.send(mqMessage, messageProperties);
    }

    @Async
    public void send(String routingKey, Object message) {
        this.send("", routingKey, message);
    }

    @Async
    public void send(String routingKey, Object message, Map<String, String> headers) {
        this.send("", routingKey, message, headers);
    }

    @Async
    public void send(String exchangeName, String routingKey, Object message) {
        this.send(exchangeName, routingKey, message, null);
    }

    @Async
    public void send(String exchangeName, String routingKey, Object message, Map<String, String> headers) {
        MQMessage mqMessage = new MQMessage();
        mqMessage.setExchangeName(exchangeName);
        mqMessage.setRoutingKey(routingKey);
        mqMessage.setQueueName(routingKey);
        mqMessage.setStatus(100);
        mqMessage.setMessage(message);
        this.send(mqMessage, headers);
    }

    @Async
    public void retrySend(MQMessage mqMessage) {
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException e) {
            LoggerUtils.errorTrace(this.getClass().getName(), "Thread.sleep.InterruptedException:" + e.getMessage());
            Thread.currentThread().interrupt();
        }
        mqMessage.doRetry();
        this.send(mqMessage, mqMessage.getHeaders());
    }

    public void saveMQMessage(MQMessage mqMessage) {
        try {
            this.mongoTemplate.save((Object)mqMessage, "mq_messages");
        }
        catch (Exception e) {
            LoggerUtils.errorTrace(this.getClass().getName(), String.format("%s\n%s_updateMQModel_error:%s", mqMessage.toString(), mqMessage.getTraceId(), e.getMessage()));
        }
    }

    public MQMessage findMQMessageByTraceId(String traceId) {
        MQMessage mqMessage = null;
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"traceId").is((Object)traceId));
            mqMessage = (MQMessage)this.mongoTemplate.findOne(query, MQMessage.class, "mq_messages");
        }
        catch (Exception e) {
            LoggerUtils.errorTrace(this.getClass().getName(), String.format("%s_query_error:%s", traceId, e.getMessage()));
        }
        return mqMessage;
    }

    public void updateStatus(String traceId, int status, String error) {
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"traceId").is((Object)traceId));
            Update update = new Update();
            update.set("status", (Object)status);
            if (StringUtils.isNotBlank((CharSequence)error)) {
                update.set("confirmMessage", (Object)error);
            }
            this.mongoTemplate.updateMulti(query, update, "mq_messages");
        }
        catch (Exception e) {
            LoggerUtils.errorTrace(this.getClass().getName(), String.format("%s_query_error:%s", traceId, e.getMessage()));
        }
    }

    public void updateConsume(String traceId, int times, String message) {
        try {
            Query query = new Query((CriteriaDefinition)Criteria.where((String)"traceId").is((Object)traceId));
            Update update = new Update();
            update.set("consumeTimes", (Object)times);
            update.set("consumeMessage", (Object)message);
            this.mongoTemplate.updateMulti(query, update, "mq_messages");
        }
        catch (Exception e) {
            LoggerUtils.errorTrace(this.getClass().getName(), String.format("%s_query_error:%s", traceId, e.getMessage()));
        }
    }
}

