/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.mq;

import com.digiwin.athena.bpm.common.util.LoggerUtils;
import com.digiwin.athena.bpm.common.util.SpringContextUtil;
import com.digiwin.athena.bpm.mq.MQMessage;
import com.digiwin.athena.bpm.mq.MQMessageService;
import java.util.Objects;
import org.springframework.amqp.rabbit.connection.CorrelationData;
import org.springframework.amqp.rabbit.core.RabbitTemplate;

public class MQProducerConfirm
implements RabbitTemplate.ConfirmCallback {
    public void confirm(CorrelationData correlationData, boolean ack, String cause) {
        MQMessageService mqMessageService = SpringContextUtil.getBean("mqMessageService", MQMessageService.class);
        MQMessage mqMessage = mqMessageService.findMQMessageByTraceId(correlationData.getId());
        if (Objects.isNull(mqMessage)) {
            LoggerUtils.infoTrace("", String.format("\n|** tag=%s;\n|** ack=%s;\n|** cause=%s", correlationData.getId(), ack, cause));
            return;
        }
        if (ack) {
            mqMessageService.updateStatus(correlationData.getId(), 200, null);
        } else {
            mqMessage.setStatus(501);
            mqMessage.setConfirmMessage(cause);
            if (mqMessage.getRetryTimes() < 2) {
                mqMessageService.retrySend(mqMessage);
            } else {
                mqMessageService.saveMQMessage(mqMessage);
            }
        }
    }
}

