/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.persistence.handler;

import com.baomidou.mybatisplus.core.handlers.MetaObjectHandler;
import com.digiwin.athena.bpm.common.generator.SnowflakeWorker;
import com.digiwin.athena.bpm.common.security.SecurityUtil;
import com.digiwin.athena.bpm.common.security.UserProfile;
import com.digiwin.athena.bpm.common.util.DateUtils;
import com.digiwin.athena.bpm.persistence.domain.BaseMgrEntity;
import com.digiwin.athena.bpm.persistence.domain.IdEntity;
import java.util.Date;
import java.util.Map;
import java.util.Objects;
import org.apache.ibatis.reflection.MetaObject;

public class EntityMetaObjectHandler
implements MetaObjectHandler {
    public void insertFill(MetaObject metaObject) {
        if (this.checkIdEntityObject(metaObject)) {
            this.setFieldValByNameForNull("id", SnowflakeWorker.nextId(), metaObject);
        }
        if (this.checkMetaObject(metaObject)) {
            UserProfile userProfile = SecurityUtil.getUserProfile();
            this.setFieldValByNameForNull("tenantId", userProfile.getTenantId(), metaObject);
            this.setFieldValByName("createdBy", userProfile.getUserId(), metaObject);
            Date date = DateUtils.getDateTimeNow();
            this.setFieldValByName("createdTime", date, metaObject);
            this.setFieldValByName("updatedBy", userProfile.getUserId(), metaObject);
            this.setFieldValByName("updatedTime", date, metaObject);
        }
    }

    private boolean checkMetaObject(MetaObject metaObject) {
        boolean isDataEntity = false;
        if (metaObject.getOriginalObject() instanceof Map) {
            Map map = (Map)metaObject.getOriginalObject();
            for (String next : map.keySet()) {
                if (!(map.get(next) instanceof BaseMgrEntity)) continue;
                isDataEntity = true;
                break;
            }
        }
        return isDataEntity || metaObject.getOriginalObject() instanceof BaseMgrEntity;
    }

    private boolean checkIdEntityObject(MetaObject metaObject) {
        boolean isIdEntity = false;
        if (metaObject.getOriginalObject() instanceof Map) {
            Map map = (Map)metaObject.getOriginalObject();
            for (String next : map.keySet()) {
                if (!(map.get(next) instanceof IdEntity)) continue;
                isIdEntity = true;
                break;
            }
        }
        return isIdEntity || metaObject.getOriginalObject() instanceof IdEntity;
    }

    private void setFieldValByNameForNull(String fieldName, Object fieldVal, MetaObject metaObject) {
        Object val = metaObject.getValue(fieldName);
        if (Objects.nonNull(val)) {
            return;
        }
        this.setFieldValByName(fieldName, fieldVal, metaObject);
    }

    public void updateFill(MetaObject metaObject) {
        if (this.checkMetaObject(metaObject)) {
            UserProfile userProfile = SecurityUtil.getUserProfile();
            this.setFieldValByName("updatedBy", userProfile.getUserId(), metaObject);
            this.setFieldValByName("updatedTime", DateUtils.getDateTimeNow(), metaObject);
        }
    }
}

