/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.persistence.handler;

import com.digiwin.athena.bpm.common.util.JsonUtils;
import com.fasterxml.jackson.core.type.TypeReference;
import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.type.BaseTypeHandler;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.MappedJdbcTypes;
import org.apache.ibatis.type.MappedTypes;

@MappedTypes(value={Map.class})
@MappedJdbcTypes(value={JdbcType.VARCHAR})
public class SqlMapTypeHandler
extends BaseTypeHandler<Map<String, Object>> {
    public void setNonNullParameter(PreparedStatement preparedStatement, int i, Map<String, Object> stringObjectMap, JdbcType jdbcType) throws SQLException {
        preparedStatement.setString(i, JsonUtils.toJson(stringObjectMap));
    }

    public Map<String, Object> getNullableResult(ResultSet resultSet, String columnName) throws SQLException {
        String sqlJson = resultSet.getString(columnName);
        if (StringUtils.isNotBlank((CharSequence)sqlJson)) {
            return (Map)JsonUtils.jsonToType(sqlJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return null;
    }

    public Map<String, Object> getNullableResult(ResultSet resultSet, int i) throws SQLException {
        String sqlJson = resultSet.getString(i);
        if (StringUtils.isNotBlank((CharSequence)sqlJson)) {
            return (Map)JsonUtils.jsonToType(sqlJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return null;
    }

    public Map<String, Object> getNullableResult(CallableStatement callableStatement, int i) throws SQLException {
        String sqlJson = callableStatement.getString(i);
        if (StringUtils.isNotBlank((CharSequence)sqlJson)) {
            return (Map)JsonUtils.jsonToType(sqlJson, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        return null;
    }
}

