/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.resource;

import com.alibaba.fastjson.JSONObject;
import com.digiwin.app.resource.DWModuleMessageResourceBundleUtils;
import com.digiwin.app.resource.DWModuleResourceBundleUtils;
import com.digiwin.athena.bpm.common.util.LoggerUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;

@Component
public class MessageResourceUtils {
    static List<String> LanguageSupports = new ArrayList<String>();

    public MessageResourceUtils(@Value(value="${moduleLanguageSupports:}") String languageSupport) {
        LanguageSupports.add("zh_CN");
        LanguageSupports.add("zh_TW");
        LanguageSupports.add("en_US");
        if (StringUtils.isNotEmpty((CharSequence)languageSupport)) {
            LanguageSupports.addAll(Arrays.asList(languageSupport.split(",")));
        }
    }

    public static String getBundle(String bundleKey, Object ... patternArguments) {
        int idx = bundleKey.indexOf(46);
        String bundleName = bundleKey.substring(0, idx);
        String key = bundleKey.substring(idx + 1);
        return DWModuleResourceBundleUtils.getString((String)bundleName, (String)key, (Object[])patternArguments);
    }

    public static String getBundleByModule(String moduleName, String bundleKey, Object ... patternArguments) {
        int idx = bundleKey.indexOf(46);
        String bundleName = bundleKey.substring(0, idx);
        String key = bundleKey.substring(idx + 1);
        return DWModuleResourceBundleUtils.getStringByModule((String)moduleName, (String)bundleName, (String)key, (Object[])patternArguments);
    }

    public static JSONObject getAllBundle(String bundleKey, Object ... patternArguments) {
        JSONObject jsonObject = new JSONObject();
        int idx = bundleKey.indexOf(46);
        String bundleName = bundleKey.substring(0, idx);
        String key = bundleKey.substring(idx + 1);
        Locale locale = MessageResourceUtils.getLocale();
        LanguageSupports.forEach(lang -> {
            MessageResourceUtils.setLocale(lang);
            jsonObject.put(lang, (Object)DWModuleResourceBundleUtils.getString((String)bundleName, (String)key, (Object[])patternArguments));
        });
        MessageResourceUtils.setLocale(locale);
        return jsonObject;
    }

    public static JSONObject getAllBundleByModule(String moduleName, String bundleKey, Object ... patternArguments) {
        JSONObject jsonObject = new JSONObject();
        int idx = bundleKey.indexOf(46);
        String bundleName = bundleKey.substring(0, idx);
        String key = bundleKey.substring(idx + 1);
        Locale locale = MessageResourceUtils.getLocale();
        LanguageSupports.forEach(lang -> {
            MessageResourceUtils.setLocale(lang);
            jsonObject.put(lang, (Object)DWModuleResourceBundleUtils.getStringByModule((String)moduleName, (String)bundleName, (String)key, (Object[])patternArguments));
        });
        MessageResourceUtils.setLocale(locale);
        return jsonObject;
    }

    public static String getMessageBundle(String resourceName, Object ... params) {
        return DWModuleMessageResourceBundleUtils.getString((String)resourceName, (Object[])params);
    }

    public static void setLocale(String locale) {
        String[] locales = locale.split("_");
        if (locales.length > 1) {
            MessageResourceUtils.setLocale(new Locale(locales[0], locales[1]));
        } else {
            MessageResourceUtils.setLocale(new Locale(locale));
        }
    }

    public static Locale getLocale() {
        return LocaleContextHolder.getLocale();
    }

    public static void setLocale(Locale locale) {
        LocaleContextHolder.setLocale((Locale)locale);
    }

    public static void removeLocaleContext() {
        LocaleContextHolder.resetLocaleContext();
    }

    public static String languageName() {
        return LocaleContextHolder.getLocale().toString();
    }

    public static String getLang(String context) {
        return MessageResourceUtils.getLang(context, MessageResourceUtils.languageName());
    }

    public static String getLang(String context, String lang) {
        if (StringUtils.isEmpty((CharSequence)context)) {
            return context;
        }
        JSONObject jsonObject = MessageResourceUtils.langToJson(context);
        if (Objects.isNull(jsonObject)) {
            return context;
        }
        if (jsonObject.containsKey((Object)lang)) {
            return jsonObject.getString(lang);
        }
        String resultLang = null;
        for (String _lang : LanguageSupports) {
            if (!jsonObject.containsKey((Object)_lang)) continue;
            resultLang = jsonObject.getString(_lang);
            break;
        }
        return resultLang;
    }

    public static JSONObject langToJson(String context) {
        String _context = context.trim();
        if (_context.startsWith("{") && _context.endsWith("}")) {
            return JSONObject.parseObject((String)context);
        }
        LoggerUtils.debugTrace("ResourceMessageUtils", "langToJson(String context)=>context Not a legal format ({key:value...})");
        return null;
    }
}

