/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.schedule;

import com.digiwin.app.container.DWContainerContext;
import com.digiwin.app.container.DWDefaultParameters;
import com.digiwin.app.container.DWParameters;
import com.digiwin.app.container.exceptions.DWException;
import com.digiwin.athena.bpm.common.security.SecurityUtil;
import com.digiwin.athena.bpm.common.security.UserProfile;
import com.digiwin.athena.bpm.common.util.DateUtils;
import com.digiwin.athena.bpm.common.util.GsonUtils;
import com.digiwin.athena.bpm.common.util.IdGenerator;
import com.digiwin.athena.bpm.common.util.JsonUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.MapUtils;

public class DWSchedule {
    public static final String ADD = "addSchedule";
    public static final String DEL = "removeSchedule";
    public static final String ENABLE = "enableSchedule";
    public static final String DISABLE = "disableSchedule";
    public static final String SCHEDULE_ID_LIST = "scheduleIdList";
    public static final String PARAM_MAP = "paramMap";
    private static final String SCHEDULE_SERVICE = "IScheduleService";
    private static String MODULE_NAME = "BPM";

    public static void setModule(String module) {
        MODULE_NAME = module;
    }

    public static Object exeDWSchedule(String method, String key, Object value) throws DWException {
        try {
            Map<String, Object> profile = SecurityUtil.getProfile();
            DWDefaultParameters parameters = new DWDefaultParameters();
            parameters.put(key, (Object)GsonUtils.toObject(JsonUtils.toJson(value), Map.class));
            return DWContainerContext.getInstance().invoke("DWSys", SCHEDULE_SERVICE, method, (DWParameters)parameters, profile);
        }
        catch (Exception exception) {
            throw new DWException("900100100", "\u521b\u5efa\u6392\u7a0b\u5f02\u5e38", (Throwable)exception);
        }
    }

    public static DWScheduleBuilder builder() {
        return new DWScheduleBuilder();
    }

    public static class DWScheduleBuilder {
        private final Map<String, Object> parameters = new HashMap<String, Object>();
        private final Map<String, Object> _scheduleParam = new HashMap<String, Object>();
        private final Map<String, Object> _scheduleHeader = new HashMap<String, Object>();

        public DWScheduleBuilder scheduleId(String scheduleId) {
            this.parameters.put("schedule_id", scheduleId);
            return this;
        }

        public DWScheduleBuilder scheduleName(String scheduleName) {
            this.parameters.put("schedule_name", scheduleName);
            return this;
        }

        public DWScheduleBuilder moduleName(String moduleName) {
            this.parameters.put("module_name", moduleName);
            return this;
        }

        public DWScheduleBuilder jobName(String jobName) {
            this.parameters.put("job_name", jobName);
            return this;
        }

        public DWScheduleBuilder scheduleType(String scheduleType) {
            this.parameters.put("schedule_type", scheduleType);
            return this;
        }

        public DWScheduleBuilder enableStatus(String enableStatus) {
            this.parameters.put("enable_status", enableStatus);
            return this;
        }

        public DWScheduleBuilder description(String description) {
            this.parameters.put("description", description);
            return this;
        }

        public DWScheduleBuilder effectiveTime(String effectiveTime) {
            this.parameters.put("effective_time", effectiveTime);
            return this;
        }

        public DWScheduleBuilder expireTime(String expireTime) {
            this.parameters.put("expire_time", expireTime);
            return this;
        }

        public DWScheduleBuilder maxRuntime(String maxRuntime) {
            this.parameters.put("max_runtime", maxRuntime);
            return this;
        }

        public DWScheduleBuilder scheduleParam(Object scheduleParam) {
            this.parameters.put("schedule_param", scheduleParam);
            return this;
        }

        public DWScheduleBuilder scheduleData(Object data) {
            this._scheduleParam.put("data", data);
            return this;
        }

        public DWScheduleBuilder scheduleUser(UserProfile userProfile) {
            this._scheduleParam.put("userProfile", userProfile);
            return this;
        }

        public DWScheduleBuilder scheduleHeader(String key, Object value) {
            this._scheduleHeader.put(key, value);
            return this;
        }

        public DWScheduleBuilder nextExecuteTime(String nextExecuteTime) {
            this.parameters.put("next_execute_time", nextExecuteTime);
            return this;
        }

        public DWScheduleBuilder programCode(String programCode) {
            this.parameters.put("program_code", programCode);
            return this;
        }

        public DWScheduleBuilder allowConcurrent(String allowConcurrent) {
            this.parameters.put("is_allow_concurrent", allowConcurrent);
            return this;
        }

        public DWScheduleBuilder addParameter(String key, String value) {
            this.parameters.put(key, value);
            return this;
        }

        public Object build() throws DWException {
            if (!this.parameters.containsKey("schedule_param")) {
                this._scheduleParam.put("header", this._scheduleHeader);
                this.parameters.put("schedule_param", this._scheduleParam);
            }
            this.scheduleId(MapUtils.getString(this.parameters, (Object)"schedule_id", (String)IdGenerator.nextUUID())).scheduleParam(MapUtils.getMap(this.parameters, (Object)"schedule_param", new HashMap())).enableStatus(MapUtils.getString(this.parameters, (Object)"enable_status", (String)"Y")).allowConcurrent(MapUtils.getString(this.parameters, (Object)"is_allow_concurrent", (String)"Y")).maxRuntime(MapUtils.getString(this.parameters, (Object)"max_runtime", (String)"5")).description(MapUtils.getString(this.parameters, (Object)"description", (String)"\u6307\u5b9a\u65f6\u95f4\u6267\u884c")).moduleName(MODULE_NAME);
            return DWSchedule.exeDWSchedule(DWSchedule.ADD, DWSchedule.PARAM_MAP, this.parameters);
        }

        public Object buildCycleByMonth(String month, String jobName) throws DWException {
            return this.scheduleType("2").jobName(jobName).scheduleName(MapUtils.getString(this.parameters, (Object)"schedule_name", (String)jobName)).addParameter("month", month).build();
        }

        public Object buildCycleByDay(String weekOfMonth, String dayOfWeek, String dayOfMonth, String jobName) throws DWException {
            return this.addParameter("week_of_month", weekOfMonth).buildCycleByDay(dayOfWeek, dayOfMonth, jobName);
        }

        public Object buildCycleByDay(String dayOfWeek, String dayOfMonth, String jobName) throws DWException {
            return this.scheduleType("2").jobName(jobName).scheduleName(MapUtils.getString(this.parameters, (Object)"schedule_name", (String)jobName)).addParameter("day_of_week", dayOfWeek).addParameter("day_of_month", dayOfMonth).build();
        }

        public Object buildCycleByTime(String key, String time, String jobName) throws DWException {
            return this.scheduleType("2").jobName(jobName).scheduleName(MapUtils.getString(this.parameters, (Object)"schedule_name", (String)jobName)).addParameter(key, time).build();
        }

        public Object buildByTiming(Date dateTime, String jobName) throws DWException {
            return this.scheduleType("1").jobName(jobName).scheduleName(MapUtils.getString(this.parameters, (Object)"schedule_name", (String)jobName)).addParameter("assign_time", DateUtils.formatToString(dateTime, "yyyyMMdd HHmmss")).build();
        }
    }
}

