/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.api;

import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.athena.bpm.api.AbsProxyService;
import com.digiwin.athena.bpm.api.model.ApiErrorModel;
import com.digiwin.athena.bpm.api.model.DAPResponse;
import java.util.Map;
import java.util.Objects;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;

public abstract class AbsProxyDapService
extends AbsProxyService {
    protected AbsProxyDapService(String appId) {
        super(appId);
    }

    protected <E> E doGet(String url, Map<String, String> headers, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, headers, HttpMethod.GET, null, responseType, uriVariables);
    }

    protected <E> E doGet(String url, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, HttpMethod.GET, null, responseType, uriVariables);
    }

    protected <E> E doGet(String url, Class<E> responseType) {
        return this.doDAPExecute(url, HttpMethod.GET, null, responseType, null);
    }

    protected <E> E doGet(String url, Map<String, String> headers, Class<E> responseType) {
        return this.doDAPExecute(url, headers, HttpMethod.GET, null, responseType, null);
    }

    protected <E> E doPost(String url, Object body, Map<String, String> headers, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, headers, HttpMethod.POST, body, responseType, uriVariables);
    }

    protected <E> E doPost(String url, Object body, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, HttpMethod.POST, body, responseType, uriVariables);
    }

    protected <E> E doPost(String url, Object body, Map<String, String> headers, Class<E> responseType) {
        return this.doDAPExecute(url, headers, HttpMethod.POST, body, responseType, null);
    }

    protected <E> E doPost(String url, Object body, Class<E> responseType) {
        return this.doDAPExecute(url, HttpMethod.POST, body, responseType, null);
    }

    protected <E> E doPut(String url, Object body, Map<String, String> headers, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, headers, HttpMethod.PUT, body, responseType, uriVariables);
    }

    protected <E> E doPut(String url, Object body, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, HttpMethod.PUT, body, responseType, uriVariables);
    }

    protected <E> E doPut(String url, Object body, Map<String, String> headers, Class<E> responseType) {
        return this.doDAPExecute(url, headers, HttpMethod.PUT, body, responseType, null);
    }

    protected <E> E doPut(String url, Object body, Class<E> responseType) {
        return this.doDAPExecute(url, HttpMethod.PUT, body, responseType, null);
    }

    protected <E> E doDelete(String url, Map<String, String> headers, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, headers, HttpMethod.DELETE, null, responseType, uriVariables);
    }

    protected <E> E doDelete(String url, Class<E> responseType, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, HttpMethod.DELETE, null, responseType, uriVariables);
    }

    protected <E> E doDelete(String url, Map<String, String> headers, Class<E> responseType) {
        return this.doDAPExecute(url, headers, HttpMethod.DELETE, null, responseType, null);
    }

    protected <E> E doDelete(String url, Class<E> responseType) {
        return this.doDAPExecute(url, HttpMethod.DELETE, null, responseType, null);
    }

    protected <E> E doDAPExecute(String url, HttpMethod httpMethod, Object request, Class<E> clazz, Map<String, Object> uriVariables) {
        return this.doDAPExecute(url, null, httpMethod, request, clazz, uriVariables);
    }

    protected <E> E doDAPExecute(String url, Map<String, String> headers, HttpMethod httpMethod, Object request, Class<E> clazz, Map<String, Object> uriVariables) {
        ResponseEntity<DAPResponse<Object>> response = this.doExecute(url, headers, httpMethod, request, new ParameterizedTypeReference<DAPResponse<Object>>(){}, uriVariables);
        DAPResponse body = (DAPResponse)response.getBody();
        if (Objects.isNull(body)) {
            ApiErrorModel apiErrorModel = ApiErrorModel.builder().appId(this.getAppId()).domain(this.getDomainUrl()).uri(url).errorCode("NullPointer").errorMessage("ResponseEntity body(DAPResponse) NullPointerException ").build();
            throw new DWRuntimeException("NullPointer", apiErrorModel.toString());
        }
        if (!HttpStatus.OK.equals((Object)response.getStatusCode())) {
            ApiErrorModel apiErrorModel = ApiErrorModel.builder().appId(this.getAppId()).domain(this.getDomainUrl()).uri(url).errorCode(body.getErrorCode()).errorMessage(body.getErrorMessage()).description(body.getDebugInfo()).build();
            throw new DWRuntimeException(body.getErrorCode(), apiErrorModel.toString());
        }
        return body.getResponseModel(clazz);
    }
}

