/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.api;

import com.digiwin.app.common.DWApplicationConfigUtils;
import com.digiwin.app.container.exceptions.DWRuntimeException;
import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.bpm.api.ApiLogService;
import com.digiwin.athena.bpm.api.ProxyService;
import com.digiwin.athena.bpm.api.model.ApiErrorModel;
import com.digiwin.athena.bpm.api.model.ApiLogDTO;
import com.digiwin.athena.bpm.common.security.SecurityUtil;
import com.digiwin.athena.bpm.common.security.UserProfile;
import com.digiwin.athena.bpm.common.util.DateUtils;
import com.digiwin.athena.bpm.common.util.LoggerUtils;
import com.digiwin.gateway.service.permission.DWSecurityContext;
import com.digiwin.gateway.service.permission.util.DWSecurityTokenUtil;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public abstract class AbsProxyService
implements ProxyService {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ApiLogService apiLogService;
    private final String appId;
    private boolean needAppToken = false;

    public AbsProxyService(String appId) {
        this.appId = appId;
    }

    public AbsProxyService(String appId, boolean needAppToken) {
        this.appId = appId;
        this.needAppToken = needAppToken;
    }

    @Override
    public abstract String getDomainUrl();

    @Override
    public String getAppId() {
        return this.appId;
    }

    @Override
    public boolean isNeedAppToken() {
        return this.needAppToken;
    }

    protected <E> ResponseEntity<E> doGet(String url, Map<String, String> headers, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, headers, HttpMethod.GET, null, responseType, uriVariables);
    }

    protected <E> ResponseEntity<E> doGet(String url, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, HttpMethod.GET, null, responseType, uriVariables);
    }

    protected <E> ResponseEntity<E> doGet(String url, Map<String, String> headers, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, headers, HttpMethod.GET, null, responseType, null);
    }

    protected <E> ResponseEntity<E> doGet(String url, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, HttpMethod.GET, null, responseType, null);
    }

    protected <E> ResponseEntity<E> doPost(String url, Object body, Map<String, String> headers, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, headers, HttpMethod.POST, body, responseType, uriVariables);
    }

    protected <E> ResponseEntity<E> doPost(String url, Object body, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, HttpMethod.POST, body, responseType, uriVariables);
    }

    protected <E> ResponseEntity<E> doPost(String url, Object body, Map<String, String> headers, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, headers, HttpMethod.POST, body, responseType, null);
    }

    protected <E> ResponseEntity<E> doPost(String url, Object body, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, HttpMethod.POST, body, responseType, null);
    }

    protected <E> ResponseEntity<E> doPut(String url, Object body, Map<String, String> headers, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, headers, HttpMethod.PUT, body, responseType, uriVariables);
    }

    protected <E> ResponseEntity<E> doPut(String url, Object body, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, HttpMethod.PUT, body, responseType, null);
    }

    protected <E> ResponseEntity<E> doPut(String url, Object body, Map<String, String> headers, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, headers, HttpMethod.PUT, body, responseType, null);
    }

    protected <E> ResponseEntity<E> doPut(String url, Object body, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, HttpMethod.PUT, body, responseType, null);
    }

    protected <E> ResponseEntity<E> doDelete(String url, Map<String, String> headers, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, headers, HttpMethod.DELETE, null, responseType, uriVariables);
    }

    protected <E> ResponseEntity<E> doDelete(String url, Map<String, String> headers, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, headers, HttpMethod.DELETE, null, responseType, null);
    }

    protected <E> ResponseEntity<E> doDelete(String url, ParameterizedTypeReference<E> responseType) {
        return this.doExecute(url, HttpMethod.DELETE, null, responseType, null);
    }

    protected <E> ResponseEntity<E> doExecute(String url, HttpMethod httpMethod, Object request, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        return this.doExecute(url, null, httpMethod, request, responseType, uriVariables);
    }

    protected <E> ResponseEntity<E> doExecute(String url, Map<String, String> headers, HttpMethod httpMethod, Object request, ParameterizedTypeReference<E> responseType, Map<String, Object> uriVariables) {
        Object object;
        ResponseEntity responseEntity = null;
        ApiLogDTO apiLogDTO = new ApiLogDTO();
        int status = 500;
        try {
            HttpHeaders httpHeaders = new HttpHeaders();
            httpHeaders.add("Content-Type", "application/json;charset=UTF-8");
            headers = this.processHeader(headers);
            headers.forEach((arg_0, arg_1) -> ((HttpHeaders)httpHeaders).add(arg_0, arg_1));
            String tFullUrl = this.getDomainUrl() + url;
            apiLogDTO.setAppId(this.appId);
            apiLogDTO.setUri(url);
            apiLogDTO.addRequest("url", tFullUrl);
            apiLogDTO.addRequest("method", httpMethod.toString());
            apiLogDTO.addRequest("header", httpHeaders);
            apiLogDTO.addRequest("variables", uriVariables);
            apiLogDTO.addRequest("body", request);
            HttpEntity httpEntity = new HttpEntity(request, (MultiValueMap)httpHeaders);
            apiLogDTO.setStartTime(DateUtils.getDateTimeNow());
            long s = System.currentTimeMillis();
            responseEntity = MapUtils.isEmpty(uriVariables) ? this.restTemplate.exchange(tFullUrl, httpMethod, httpEntity, responseType, new Object[0]) : this.restTemplate.exchange(tFullUrl, httpMethod, httpEntity, responseType, uriVariables);
            apiLogDTO.setDuration(System.currentTimeMillis() - s);
            apiLogDTO.setEndTime(DateUtils.getDateTimeNow());
            apiLogDTO.setStatus(200);
            status = responseEntity.getStatusCode().value();
            apiLogDTO.addResponse("status", status);
            object = responseEntity == null ? new HashMap() : responseEntity.getBody();
        }
        catch (Exception exception) {
            try {
                apiLogDTO.setStatus(500);
                ApiErrorModel apiErrorModel = ApiErrorModel.builder().code("500").appId(this.appId).domain(this.getDomainUrl()).uri(url).errorCode("404").errorMessage(exception.getMessage()).build();
                apiLogDTO.addResponse("exception", apiErrorModel);
                throw new DWRuntimeException(this.appId + "_500", apiErrorModel.toString());
            }
            catch (Throwable throwable) {
                apiLogDTO.addResponse("status", status);
                apiLogDTO.addResponse("body", responseEntity == null ? new HashMap() : responseEntity.getBody());
                this.apiLogService.save(apiLogDTO);
                throw throwable;
            }
        }
        apiLogDTO.addResponse("body", object);
        this.apiLogService.save(apiLogDTO);
        return responseEntity;
    }

    protected Map<String, String> processHeader(Map<String, String> headers) {
        UserProfile userProfile;
        if (MapUtils.isEmpty(headers)) {
            headers = new HashMap<String, String>();
        }
        if (StringUtils.isNotEmpty((CharSequence)(userProfile = SecurityUtil.getUserProfile()).getToken())) {
            if (!headers.containsKey("digi-middleware-auth-user")) {
                headers.put("digi-middleware-auth-user", userProfile.getToken());
            }
            if (!headers.containsKey("token")) {
                headers.put("token", userProfile.getToken());
            }
        }
        if (!headers.containsKey("routerKey") && StringUtils.isNotEmpty((CharSequence)userProfile.getTenantId())) {
            headers.put("routerKey", userProfile.getTenantId());
        }
        if (this.needAppToken && !headers.containsKey("digi-middleware-auth-app")) {
            headers.put("digi-middleware-auth-app", DWApplicationConfigUtils.getProperty((String)"iamApToken"));
        }
        DWServiceContext context = DWServiceContext.getContext();
        Map requestHeader = context.getRequestHeader();
        String securityToken = "";
        if (Objects.nonNull(requestHeader) && requestHeader.containsKey("security-token")) {
            securityToken = String.valueOf(requestHeader.get("security-token"));
        } else {
            try {
                DWSecurityContext securityContext = DWSecurityContext.getSecurityContext();
                if (!securityContext.isTokenVerified()) {
                    securityContext.setProfile(context.getProfile());
                    securityContext.setAppToken(DWApplicationConfigUtils.getProperty((String)"iamApToken"));
                    securityContext.setTokenVerified();
                }
                securityToken = DWSecurityTokenUtil.generateSecurityToken((DWSecurityContext)securityContext);
            }
            catch (Exception e) {
                securityToken = "";
                LoggerUtils.errorTrace(this.getClass(), ExceptionUtils.getStackTrace((Throwable)e));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)securityToken)) {
            headers.put("security-token", securityToken);
        }
        return headers;
    }
}

