/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.api;

import com.digiwin.athena.bpm.api.ApiLogService;
import com.digiwin.athena.bpm.api.model.ApiLogDTO;
import com.digiwin.athena.bpm.common.util.GsonUtils;
import com.digiwin.athena.bpm.common.util.LoggerUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.scheduling.annotation.Async;

public class ApiLogServiceImpl
implements ApiLogService {
    private final MongoTemplate mongoTemplate;
    private final String appId;
    private final String collectionName;
    private final boolean closeLog;

    public ApiLogServiceImpl(MongoTemplate mongoTemplate, String appId, String collectionName, boolean closeLog) {
        this.mongoTemplate = mongoTemplate;
        this.appId = appId;
        this.collectionName = collectionName;
        this.closeLog = closeLog;
    }

    public ApiLogServiceImpl(MongoTemplate mongoTemplate, String appId, String collectionName) {
        this.mongoTemplate = mongoTemplate;
        this.appId = appId;
        this.collectionName = collectionName;
        this.closeLog = false;
    }

    @Override
    @Async
    public void save(ApiLogDTO apiLogDTO) {
        if (this.closeLog) {
            return;
        }
        try {
            if (StringUtils.isBlank((CharSequence)apiLogDTO.getAppId())) {
                apiLogDTO.setAppId(this.appId);
            }
            if (MapUtils.isEmpty(apiLogDTO.getFootprint())) {
                this.mongoTemplate.insert((Object)apiLogDTO.toDocument(), this.collectionName);
            } else {
                this.mongoTemplate.insert((Object)apiLogDTO.toDocument(), "api_footprints");
            }
        }
        catch (Exception exception) {
            LoggerUtils.errorTrace(this.getClass(), String.format("_save:Exception[%s]Json[%s]", exception.getMessage(), GsonUtils.toJson(apiLogDTO)));
        }
    }

    public boolean isCloseLog() {
        return this.closeLog;
    }
}

