/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.aspect;

import com.digiwin.app.service.DWServiceContext;
import com.digiwin.athena.bpm.common.domain.BaseDoc;
import com.digiwin.athena.bpm.common.util.DateUtils;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class MongoRepositoryAspect {
    @Pointcut(value="execution(* org.springframework.data.mongodb.core.MongoTemplate.save(..)) || execution(* org.springframework.data.mongodb.core.MongoTemplate.insert(..))")
    public void insertOrSave() {
    }

    @Around(value="insertOrSave()")
    public Object beforeInsertOrSave(ProceedingJoinPoint pjp) throws Throwable {
        Object[] args;
        for (Object arg : args = pjp.getArgs()) {
            if (arg instanceof Collection) {
                Collection objects = (Collection)arg;
                for (Object obj : objects) {
                    if (!(obj instanceof BaseDoc)) continue;
                    this.setManagerFieldsValue((BaseDoc)obj);
                }
                continue;
            }
            if (!(arg instanceof BaseDoc)) continue;
            this.setManagerFieldsValue((BaseDoc)arg);
        }
        return pjp.proceed();
    }

    private void setManagerFieldsValue(BaseDoc doc) {
        Object userId = this.getDapProfile("userId");
        if (Objects.isNull(doc.getId())) {
            Object tenantId;
            if (!Objects.isNull(userId) && Objects.isNull(doc.getCreatedBy())) {
                doc.setCreatedBy(String.valueOf(userId));
            }
            if (!Objects.isNull(tenantId = this.getDapProfile("tenantId")) && Objects.isNull(doc.getTenantId())) {
                doc.setTenantId(String.valueOf(tenantId));
            }
            doc.setCreatedTime(DateUtils.getDateTimeNow());
        } else {
            if (!Objects.isNull(userId) && Objects.isNull(doc.getUpdatedBy())) {
                doc.setUpdatedBy(String.valueOf(userId));
            }
            doc.setUpdatedTime(DateUtils.getDateTimeNow());
        }
    }

    private Object getDapProfile(String key) {
        Map profile = DWServiceContext.getContext().getProfile();
        if (Objects.isNull(profile)) {
            return null;
        }
        return profile.get(key);
    }
}

