/*
 * Decompiled with CFR 0.152.
 */
package com.digiwin.athena.bpm.common.domain;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;

public class Pagination {
    private long pageIndex = 1L;
    private long pageSize = 10L;
    private long pageCount;
    private long recordCount;
    public static final String DESC = "DESC";
    public static final String ASC = "ASC";
    private final LinkedHashMap<String, String> orderBy = new LinkedHashMap();

    public long getRecordIndex() {
        return (this.getPageIndex() - 1L) * this.getPageSize();
    }

    public long getPageIndex() {
        return this.pageIndex;
    }

    public long getPage() {
        return this.pageIndex - 1L;
    }

    public void setPageIndex(long pageIndex) {
        this.pageIndex = pageIndex;
        if (this.pageIndex < 1L) {
            this.pageIndex = 1L;
        }
    }

    public long getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(long pageSize) {
        this.pageSize = pageSize;
    }

    public long getPageCount() {
        return this.pageCount;
    }

    public void setPageCount(long pageCount) {
        this.pageCount = pageCount;
    }

    public long getRecordCount() {
        return this.recordCount;
    }

    public void setRecordCount(long recordCount) {
        this.recordCount = recordCount;
        this.pageCount = this.recordCount / this.pageSize;
        if (this.recordCount % this.pageSize > 0L) {
            ++this.pageCount;
        }
        if (this.pageIndex > this.pageCount) {
            this.setPageIndex(this.pageCount);
        }
    }

    public Pagination addOrderDesc(String key) {
        this.orderBy.put(key, DESC);
        return this;
    }

    public Pagination addOrderAsc(String key) {
        this.orderBy.put(key, ASC);
        return this;
    }

    public Map<String, String> getOrderBy() {
        return this.orderBy;
    }

    public static Pagination builder(long index, long size) {
        Pagination pagination = new Pagination();
        pagination.setPageIndex(index);
        pagination.setPageSize(size);
        return pagination;
    }

    public String getQuerySqlByOrder(String sql) {
        ArrayList orderSQL = new ArrayList();
        this.orderBy.forEach((key, value) -> orderSQL.add(String.format(" %s %s", key, value)));
        String newSql = sql;
        if (!orderSQL.isEmpty()) {
            newSql = sql + "order by " + String.join((CharSequence)",", orderSQL);
        }
        return newSql;
    }
}

